<?php

namespace App\Models\DTR;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class User extends Model implements AuditableContract
{
    use SoftDeletes;
    use Auditable;

    protected $connection= 'dtr';

    public function timelogs()
    {
        return $this->hasMany(Timelog::class, 'user_id');
    }

    public function getTimezoneAttribute()
    {
        $timezone = null;

        switch ($this->location) {
            case 'AU':
                $timezone = 'Australia/Melbourne';
                break;
            
            default:
                $timezone = 'Asia/Manila';
                break;
        }

        return $timezone;
    }
}
