<?php

namespace App\Models\DTR;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class TimelogBreak extends Model implements AuditableContract
{
    use SoftDeletes;
    use Auditable;

    protected $connection= 'dtr';

    protected $dates = [
        'break_start',
        'break_end',
        'created_at'
    ];

    public function timelog()
    {
        return $this->hasOne(Timelog::class, 'id', 'timelog_id');
    }
}
