<?php

namespace App\Models\DTR;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class Timelog extends Model implements AuditableContract
{
    use SoftDeletes;
    use Auditable;

    protected $connection= 'dtr';
    
    protected $table="timelog";

    protected $casts = [
        'time_in' => 'datetime',
        'time_out' => 'datetime'
    ];

    public function user()
    {
        // return $this->hasOne(User::class, 'user_id');
        return $this->belongsTo(User::class);
    }

    public function breaks()
    {
        return $this->hasMany(TimelogBreak::class);
    }
}
