<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use Illuminate\Database\Eloquent\SoftDeletes;

class ContactDetail extends Model implements AuditableContract
{
    //
    use Auditable;
    use SoftDeletes;

    protected $fillable = [
        'address_1',
        'address_2',
        'country_id',
        'state',
        'postcode',
        'phones',
        // 'phone_1',
        // 'phone_2',
        // 'phone_3',
        'email',
        'email_alt',
        'emer_name',
        'emer_email',
        'emer_address',
        'emer_phone',
        'emer_relationship',
        'home_country_res_addr',
    ];

    protected $casts = ['phones' => 'array'];

    public function person()
    {
        return $this->belongsTo(Person::class, 'person_id', 'id');
    }

    public function country()
    {
        // return $this->belongsTo(Country::class, 'country_id', 'id');
        return $this->belongsTo(AvtCountryIdentifier::class, 'country_id', 'id');
    }

    public function client_detail()
    {
        return $this->belongsTo(ClientDetail::class);
    }
}
