<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientService extends Model implements AuditableContract
{
    //
    use Auditable;
    use SoftDeletes;

    protected $fillable = [
        'service_code',
        'service_name',
        'service_details',
        'amount',
        'date_approved',
        'date_expired',
        'is_withdrawn',
    ];

    protected $casts = [
        'service_details' => 'array'
    ];

    public function assigned_to()
    {
        return $this->belongsTo(User::class, 'assigned_to_id');
    }

    public function deal()
    {
        return $this->belongsTo(Deal::class);
    }
}
