<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientReminder extends Model implements AuditableContract
{
    //
    use Auditable;
    use SoftDeletes;

    protected $fillable = [
        'subject',
        'content',
        'reminders_to',
        'reminder_date',
        'reminder_time',
        'is_active',
        'is_sent',
        'is_done',
    ];

    protected $casts = [
        'reminders_to' => 'array'
    ];

    public function deal()
    {
        return $this->belongsTo(Deal::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
