<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientDetail extends Model implements AuditableContract
{
    //
    use Auditable;
    use SoftDeletes;

    protected $fillable = [
        'customer_id',
        'old_customer_id',
        'nationality_id',
        'current_visa_status',
        'expiration_date',
        'passport_no',
        'fifth_call',
        'college_currently_enroled',
        'referrer_customer_id',
        'client_member',
        'client_member_card_no',
        'hear_about_us',
        'agent_id',
        'assigned_to',
    ];

    public function deal()
    {
        return $this->belongsTo(Deal::class, 'deal_id');
    }

    public function contact_detail()
    {
        return $this->hasOne(ContactDetail::class);
    }

    public function nationality()
    {
        return $this->belongsTo(AvtCountryIdentifier::class, 'nationality_id');
    }

    public function visa_status()
    {
        return $this->belongsTo(VisaStatus::class, 'current_visa_status');
    }

    public function agent()
    {
        return $this->belongsTo(Agent::class, 'agent_id');
    }

    public function assigned()
    {
        return $this->belongsTo(User::class, 'assigned_to');
    }

    public function referrer()
    {
        return $this->belongsTo(ClientDetail::class, 'referrer_customer_id', 'customer_id');
    }
}
