<?php

namespace App\Http\Resources;

use App\Models\Deal;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class ClientResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        // dd($this);
        // return parent::toArray($request);
        $deal = Deal::where('id', $this->id)->first();

        // $phone = [];
        // if(isset($deal->party->person->contact_detail->phone_1)) {
        //     $phone[] = $deal->party->person->contact_detail->phone_1;
        // }
        // if(isset($deal->party->person->contact_detail->phone_2)) {
        //     $phone[] = $deal->party->person->contact_detail->phone_2;
        // }
        // if(isset($deal->party->person->contact_detail->phone_3)) {
        //     $phone[] = $deal->party->person->contact_detail->phone_3;
        // }
        // dump($this->client_detail->customer_id);
        $email = isset($this->client_detail->contact_detail->email) && $this->client_detail->contact_detail->email != null ? $this->client_detail->contact_detail->email : '';

        return [
            'deal_id' => $this->id,
            'customer_id' => isset($this->client_detail->customer_id) ? $this->client_detail->customer_id : '',
            'name' => $this->party->name,
            'deal_type' => $this->deal_type->type,
            'email' => $email,
            'phone' => isset($this->client_detail->contact_detail->phones) ? implode(', ', $this->client_detail->contact_detail->phones) : '',
            'notes' => $this->notes->count(),
            'convos' => $this->convos->count(),
            'attachments' => $this->attachments->count(),
            'is_online_inquiry' => $deal->is_online_inquiry,
        ];

    }
}
