<?php

namespace App\Http\Resources;

use App\Models\Deal;
use Carbon\Carbon;
// use Illuminate\Http\Resources\Json\ResourceCollection;
use Illuminate\Http\Resources\Json\JsonResource;

class ClientReminderCollection extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        // return parent::toArray($request);

        // dd($this->deal->client_detail->contact_detail->phones);

        return [
            'id' => $this->id,
            'deal_id' => isset($this->deal->id) ? $this->deal->id : null,
            'deal' => isset($this->deal->id) ? Deal::with(['client_detail.contact_detail', 'party'])->where('id', $this->deal->id)->first() : null,
            'client_name' => isset($this->deal->party->name) ? $this->deal->party->name : '',
            // 'client_detail' => isset($this->deal->client_detail->id) ? $this->deal->client_detail : null,
            'phones' => isset($this->deal->client_detail->contact_detail->phones) && is_array($this->deal->client_detail->contact_detail->phones) ? implode(', ', $this->deal->client_detail->contact_detail->phones) : null,
            'subject' => $this->subject,
            'content' => $this->content,
            'reminders_to' => isset($this->reminders_to) ? $this->reminders_to : '',
            // 'reminders_to' => isset($this->subject) ? implode(', ', $this->subject) : '',
            'reminder_date' => isset($this->reminder_date) && !in_array($this->reminder_date, ['', null]) ? Carbon::createFromFormat('Y-m-d', $this->reminder_date)->format('d/m/Y') : '-',
            'reminder_time' => isset($this->reminder_time) ? $this->reminder_time : '-',
            'is_done' => $this->is_done,
            'is_sent' => $this->is_sent,
            'is_active' => $this->is_active,
            // 'data' => $this,
        ];
    }
}
