<?php

namespace App\Http\Controllers\TaskOrganizer;

use App\Http\Controllers\Controller;
use App\Models\TaskOrganiser\Column;
use App\Models\TaskOrganiser\Project;
use App\Models\TaskOrganiser\Subtask;
use App\Models\TaskOrganiser\SubtaskTimeTracking;
use App\Models\TaskOrganiser\Task;
use App\Models\TaskOrganiser\User;
use App\Models\User as ModelsUser;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

// use JsonRPC\Client;


class TaskOrganizerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        //
        $toUser = User::find(Auth::user()->task_organiser_id);

        if(!$toUser) {
            abort(401);
        }

        \JavaScript::put([
            'userRole' => Auth::user()->roles[0]->name,
            'toUser' => $toUser
        ]);

        return view('task-organiser.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        // dd($request->owner);
        try {

            $task = Task::where('id', $request->id)->first();
            
            DB::beginTransaction();

            $task->fill($request->all());
            
            // update task owner
            if($request->owner) {
                $task->owner()->associate(User::find($request->owner['id']));
            }
            // update column
            if($request->get_column) {
                $task->get_column()->associate(Column::find($request->get_column['id']));
            }

            $task->update();
            

            DB::commit();


            return ['status' => 'success'];

        } catch (\Throwable $th) {
            DB::rollback();
            throw $th;
        }


        // return ['status' => 'error'];
    }

    public function store_subtask(Request $request)
    {
        try {
            DB::beginTransaction();

            $subtasksCount = Subtask::where('task_id', $request->task_id)->get()->count();

            if(isset($request->id)) {
                // update
                $subtask = Subtask::find($request->id);
                $subtask->fill($request->all());
                $subtask->update();
            }else {
                // created
                $subtask = new Subtask;
                $subtask->fill($request->all());
                $subtask->position =  $subtasksCount + 1;
                $subtask->save();
            }

            DB::commit();

            return ['status' => 'success', 'subtasks' => Subtask::with(['user', 'subtask_time_tracking'])->where('task_id', $request->task_id)->get()];

        } catch (\Throwable $th) {
            DB::rollback();
            throw $th;
        }
    }

    public function action_subtask(Request $request)
    {
        $subtask = Subtask::find($request->id);
        $toUser = User::find(Auth::user()->task_organiser_id);
        
        switch ($subtask->status) {
            case 0:
                $subtask->status = 1;
                // create subtask time tracking
                $stt = new SubtaskTimeTracking;
                $stt->start = Carbon::now()->timestamp;
                $stt->end = 0;
                $stt->time_spent = 0;
                $stt->user()->associate($toUser);
                $stt->subtask()->associate($subtask);
                $stt->save();
                break;
            case 1:
                // update subtask time tracking
                $subtask->status = 2;
                $subtask->subtask_time_tracking[0]->end = Carbon::now()->timestamp;
                $time_spent = ($subtask->subtask_time_tracking[0]->end - $subtask->subtask_time_tracking[0]->start) / 3600;
                $subtask->subtask_time_tracking[0]->time_spent = round($time_spent, 2);
                $subtask->subtask_time_tracking[0]->update();
                // sum time spent
                $total = $subtask->subtask_time_tracking->sum('time_spent');
                $subtask->time_spent = $total;
                $subtask->update();
                break;
            case 2:
                $subtask->status = 0;
                
                break;
        }

        $subtask->update();

        return ['status' => 'success', 'subtasks' => Subtask::with(['user', 'subtask_time_tracking'])->where('task_id', $request->task_id)->get()];
    }

    public function create_new_task(Request $request)
    {
        try {

            DB::beginTransaction();

            $project = Project::find($request->prjID);

            $task = new Task;
            $task->title = $request->title;
            $task->date_creation = Carbon::now()->timestamp;

            // update column
            $task->get_column()->associate(Column::find($request->colID));

            // update project
            $task->project()->associate($project);

            // update task creator
            if(Auth::user()->task_organiser_id != null) {
                $task->creator()->associate(User::find(Auth::user()->task_organiser_id));
            }
            // dump($project);
            // dd($project->swimlanes);
            $task->position = 0;
            $task->score = 0;
            $task->color_id = 'blue';
            $task->swimlane_id = $project->swimlanes[0]->id;
            $task->save();
            
            DB::commit();

            return ['status' => 'success', 'task' => $task];

        } catch (\Throwable $th) {
            DB::rollback();
            throw $th;
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        // $user = User::where('id', $id)->first();
        // dump($user);
        // dd($user->appUser);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function get_project($id = 5)
    {
        // get project
        $project = Project::with([
            'columns.tasks.attachments',
            'columns.tasks.comments',
            'columns.tasks.links',
            'columns.tasks.subtasks.user',
            'columns.tasks.subtasks.subtask_time_tracking',
            'columns.tasks.done_subtasks',
            'columns.tasks.owner',
            'columns.tasks.get_column',
            'project_has_users.user'
        ])->where('id', $id)->first();
        
        if($project) {
            $project = $project->toArray();
            $prj_owners = [];
            foreach ($project['columns'] as $key => $value) {
                foreach ($value['tasks'] as $k => $v) {
                    if($v['owner']) {
                        if(isset($prj_owners[$v['owner']['id']])){
                            $project['columns'][$key]['tasks'][$k]['owner']['app_user'] = $prj_owners[$v['owner']['id']];
                        }else{
                            $app_user = ModelsUser::where('task_organiser_id', $v['owner']['id'])->first();
                            if($app_user) {
                                $project['columns'][$key]['tasks'][$k]['owner']['app_user'] = $app_user->toArray();
                                $prj_owners[$v['owner']['id']] = $app_user->toArray();
                            }
                        }
                    }
                }
            }

            // get project users
            $project['project_users'] = [];
            foreach ($project['project_has_users'] as $v) {
                $project['project_users'][] = $v['user'];
            }
        }
        
        // get owners from app
        // $project_users = Task::with('owner')->where('project_id', $id)->groupBy('owner_id')->get();
        
        // foreach ($project_users as $v) {
        //     if($v->owner) {
        //         $app_user = ModelsUser::where('task_organiser_id', $v->owner->id)->first();
        //         if($app_user) {
        //             $prj_owners[] = $app_user;
        //         }
        //     }
        // }
        return $project;
    }
    
    public function get_user_image($id)
    {
        $user = ModelsUser::where('id',$id)->first();
        return $user;
    }

    public function transfer_task(Request $request)
    {
        // dd($request->all());
        // dd($request->colTasks);
        try {
            DB::beginTransaction();

            // update task column
            $task_position = $request->task['newIndex'] + 1;
            $task = Task::where('id', $request->task['element']['id'])->first();
            $task->column_id = $request->column_id;
            $task->position = $task_position;
            $task->date_moved = Carbon::now()->timestamp;
            $task->update();
            
            // update position
            // $tasks = Task::where('project_id', $request->task['element']['project_id'])->where('column_id', $request->column_id)->orderBy('position')->get();
            $tasks = Task::where('column_id', $request->column_id)->orderBy('position')->get();
            $colTasks = $request->colTasks;
            foreach ($colTasks as $k => $v) {
                foreach ($tasks as $kk => $vv) {
                    if($v['id'] == $vv->id) {
                        $vv->position = $k + 1;
                        $vv->update();
                    }
                }
                // dump($v->title. ' - ' .$v->position);
            }

            DB::commit();


            return ['status' => 'success'];

        } catch (\Throwable $th) {
            DB::rollback();
            throw $th;
        }
    }
}
