<?php

namespace App\Http\Controllers\TaskOrganizer;

use App\Http\Controllers\Controller;
use App\Models\TaskOrganiser\Task;
use App\Models\TaskOrganiser\TaskHasFile;
use App\Models\TaskOrganiser\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class TaskAttachmentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        dd($request->all());
        // $path = '';
        // $file = null;
        // $date_uploaded = Carbon::now()->format('Y-m');
        // try {
        //     DB::beginTransaction();

        //     $file = $request->file('files');
        //     $hashFileName = preg_replace('/\\.[^.\\s]{3,4}$/', '', $file->hashName());
        //     $documents = new TaskHasFile([
        //         'name'      => $file->getClientOriginalName(),
        //         'path'      => 'tasks/',
        //         'size'      => $file->getClientSize(),
        //         'mime_type' => $file->getMimeType(),
        //         'ext'       => $file->guessClientExtension(),
        //         '_input'    => 'attachment',
        //         'version'   => '1.0',
        //         'is_current'=> '1',
        //     ]);

        //     $path = $file->store('public/documents/' . $date_uploaded . '/' . $documents->u_id . '/');

        //     // associated user
        //     $documents->user()->associate(\Auth::user());
        //     // $documents->agent()->associate($agent);
        //     $documents->save();
        //     // $documents->path_id = $agent->id;
        //     $documents->update();
        //     $attID = $documents->id;

        //     DB::commit();

        //     $file_path = '/storage/documents/'. $date_uploaded . '/' . $documents->u_id . '/' . $documents->hash_name . '.' . $documents->ext;

        //     $file = [
        //         'id' => $documents->id,
        //         'lastModified' => $documents->updated_at->timestamp,
        //         'lastModifiedDate' => $documents->updated_at,
        //         'name' => $documents->name,
        //         'size' => $documents->size,
        //         'file_path' => $file_path,
        //         'file_ext' => $documents->ext,
        //         'file_type' => explode('/', $documents->mime_type)[0],
        //     ];

        //     // return response(['status' => 'success', 'attID' => $attID, 'preview' => $preview], 200)->header('Content-Type', 'text/json');
        //     return response(['status' => 'success', 'file' => $file], 200)->header('Content-Type', 'text/json');
        //     // return response(['status' => 'success', 'attID' => 0], 200)->header('Content-Type', 'text/json');
        // } catch (\Exception $e) {
        //     DB::rollBack();

        //     // remove file
        //     Storage::delete($path);
        //     dd($e->getMessage());
        // }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $attachments = TaskHasFile::with(['task'])->where('task_id', $id)->get();

        $files = [];

        foreach ($attachments as $key => $value) {

            // dd($value->updated_at->timestamp);

            // check if file is already in local storage
            $local_path = '/public/task-organiser/'.$value->path;
            // dump($local_path);
            // dump(Storage::exists($local_path));
            if(Storage::exists($local_path) == false) {
               $file = Storage::disk('sftp')->get('/public_html/kanboard/data/files/'.$value->path);
               Storage::put($local_path, $file);
            }
            $file_path = '/storage/task-organiser/'.$value->path;
            $file_ext = pathinfo($value->name, PATHINFO_EXTENSION);
            $file_type = $value->is_image == 1 ? 'image' : '';
            // dd('check');
            array_push($files, [
                'id' => $value->id,
                'u_id' => $value->id,
                // 'lastModified' => $value->updated_at->timestamp,
                // 'lastModifiedDate' => $value->updated_at,
                'name' => str_replace('.'.$file_ext, '', $value->name),
                'size' => $value->size,
                'file_path' => $file_path,
                'is_image' => $value->is_image,
                'file_ext' => $file_ext,
                'file_type' => $file_type,
            ]);
        }

        return $files;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // dump($id);
        // dd($request->all());

        $path = '';
        $file = null;
        try {
            DB::beginTransaction();

            $file = $request->file('files');
            $hashFileName = preg_replace('/\\.[^.\\s]{3,4}$/', '', $file->hashName());
            // dump($hashFileName);
            // dump($file->getMimeType());
            $is_image = explode('/',$file->getMimeType());
            $taskFile = new TaskHasFile([
                'name'      => $file->getClientOriginalName(),
                'path'      => 'tasks/'.$id.'/'.$hashFileName,
                'size'      => $file->getClientSize(),
                'date'      => Carbon::now()->timestamp,
                'is_image' => in_array('image', $is_image) ? 1 : 0,
            ]);

            $taskFile->task()->associate(Task::find($id));
            $toUser = User::find(Auth::user()->task_organiser_id);
            $taskFile->user()->associate($toUser);
            
            $taskFile->save();

            $pathLocal = $file->storeAs('public/task-organiser/tasks/' . $id, $hashFileName);
            $pathTo = $file->storeAs('/public_html/kanboard/data/files/tasks/' . $id, $hashFileName, 'sftp');

            // dd($pathTo);

            DB::commit();

            // $file = [
            //     'id' => $documents->id,
            //     'lastModified' => $documents->updated_at->timestamp,
            //     'lastModifiedDate' => $documents->updated_at,
            //     'name' => $documents->name,
            //     'size' => $documents->size,
            //     'file_path' => $file_path,
            //     'file_ext' => $documents->ext,
            //     'file_type' => explode('/', $documents->mime_type)[0],
            // ];

            // return response(['status' => 'success', 'attID' => $attID, 'preview' => $preview], 200)->header('Content-Type', 'text/json');
            return response(['status' => 'success', 'file' => $file], 200)->header('Content-Type', 'text/json');
            // return response(['status' => 'success', 'attID' => 0], 200)->header('Content-Type', 'text/json');
        } catch (\Exception $e) {
            DB::rollBack();

            // remove file
            Storage::delete($path);
            dd($e->getMessage());
        }
    }

    public function preview($id)
    {
        $file = TaskHasFile::find($id);

        $path ='/public/task-organiser/' . $file->path;

        // raw file contents
        $fileContent = Storage::get($path);

        if(in_array(pathinfo($file->name, PATHINFO_EXTENSION), ['pdf', 'zip', 'doc', 'docx', 'csv', 'xls', 'xlsx'])){
            header("Content-Disposition: attachment; filename=".$file->name);
        }
        return response($fileContent)->header('Content-Type', mime_content_type(storage_path('app').$path));
    }

    public function rename(Request $request, $id)
    {
        // dump($request->all());
        // dd($id);
        $file = TaskHasFile::find($id);
        $file_ext = pathinfo($file->name, PATHINFO_EXTENSION);
        $file->name = $request->rename.'.'.$file_ext;
        $file->update();
        return ['status' => 'updated'];
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
