<?php

namespace App\Http\Controllers\Setup\Automation;

use App\Http\Controllers\Controller;
use App\Models\DealAttachment;
use App\Models\Documents;
use Carbon\Carbon;
use Illuminate\Http\File as HttpFile;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;

class ImageFileController extends Controller
{

    public function __construct() {
        if(in_array(env('AWS_ROOT_PATH'), ['',null])) {
            abort(403, 'Unauthorized action.');
        }
    }

    public static function apiRoutes()
    {
        Route::post('image-file/upload', [ImageFileController::class, 'upload']);
        Route::get('image-file/view/{model}/{id}', [ImageFileController::class, 'view']);

        // Deals
        Route::get('image-file/upload/deal', [ImageFileController::class, 'deal_upload']);
        
        // Documents
        Route::get('image-file/upload/document', [ImageFileController::class, 'document_upload']);
        
    }

    public static function upload($file, $id, $type)
    {
        switch ($type) {
            case 'deal':
                $aws_path = env('AWS_ROOT_PATH').'/public/client/'.$id.'/attachments';
                $path = $file->store($aws_path, 's3');
                return str_replace('//','/', $path);

                break;

            case 'document':
                $aws_path = env('AWS_ROOT_PATH').'/public/documents/'.$id;
                $path = $file->store($aws_path, 's3');
                return str_replace('//','/', $path);

                break;
        }
    }

    public static function preview($model, $download = false)
    {
        if (!$model) {
            return [
                'error' => true,
                'message' => 'No model found'
            ];
        }

        // $path = $model->aws_path;
        
        if($download) {
            return Storage::disk('s3')->download($model->aws_path, $model->name);
        }
        
        return Storage::disk('s3')->response($model->aws_path);
        
    }

    public function deal_upload()
    {
        if(!Auth::user() || Auth::user()->id != 1) {
            abort(404);
        }

        $attachments = DealAttachment::all();

        foreach ($attachments as $attachment) {

            $aws_path = env('AWS_ROOT_PATH').'/public/client/'.$attachment->deal_id.'/attachments';

            if($attachment->old_attachment_id) {
                $path = storage_path("app/public/client/{$attachment->deal_id}/attachments/{$attachment->student_id}/old/");
            } else {
                $path = storage_path("app/public/client/{$attachment->deal_id}/attachments/{$attachment->student_id}/new/");
            }

            if(in_array($attachment->aws_path, [null, '']) && file_exists($path."/{$attachment->hash_name}.{$attachment->ext}")) {   
                $file = Storage::disk('s3')->putFileAs($aws_path, new HttpFile($path."{$attachment->hash_name}.{$attachment->ext}"), "{$attachment->hash_name}.{$attachment->ext}");
                if($file) {
                    $attachment->aws_path = str_replace('//','/', $file);
                    $attachment->update();
                }
            }
            
        }

        return ['success' => true];
    }
    
    public function document_upload()
    {
        if(!Auth::user() || Auth::user()->id != 1) {
            abort(404);
        }

        $attachments = Documents::all();

        foreach ($attachments as $attachment) {
            $aws_path = env('AWS_ROOT_PATH').'/public/documents/'.$attachment->u_id;
            $date = Carbon::parse($attachment->created_at)->format('Y-m');
            $path = storage_path('app/public/documents/'.$date.'/'.$attachment->u_id .'/');
            
            if(in_array($attachment->aws_url, [null, '']) && file_exists($path."{$attachment->hash_name}.{$attachment->ext}")) {
                $file = Storage::disk('s3')->putFileAs($aws_path, new HttpFile($path."{$attachment->hash_name}.{$attachment->ext}"), "{$attachment->hash_name}.{$attachment->ext}");
                if($file) {
                    $attachment->aws_path = str_replace('//','/', $file);
                    $attachment->update();
                }
            }
            
        }

        return ['success' => true];
    }

    public function localFileRemover($type)
    {
        if(!Auth::user() || Auth::user()->id != 1) {
            abort(404);
        }

        switch ($type) {
            case 'student':

                $attachments = StudentAttachment::all();

                foreach ($attachments as $attachment) {
                    
                    $path = storage_path('app/public/student/new/attachments/'.$attachment->student_id .'/');

                    if($attachment->aws_path != null && file_exists($path."{$attachment->hash_name}.{$attachment->ext}")) {
                        Storage::delete($path."{$attachment->hash_name}.{$attachment->ext}");
                    }
                    
                }

                return ['success' => true];
                

                break;

            case 'student-coe':
                

                break;
            
            case 'student-aiss':
                

                break;

            case 'student-workbook':
                

                break;

            case 'enrolment':
                

                break;

            case 'agent':
                

                break;

            case 'agent-application':
                

                break;

            case 'document':
                

                break;
        }
    }


}