<?php

namespace App\Http\Controllers\Send;

use App\Http\Controllers\Controller;
use App\Models\Organisation;
use App\Models\Questionnaire;
use Carbon\Carbon;
use Illuminate\Http\Request;
use PHPMailer\PHPMailer\PHPMailer;

class EmailSendingController extends Controller
{
    //
    public function send_automate($subject, $content, $emailFrom, $emailsTo, $paths = [], $emailsBcc = [])
    {
      $mail = new PHPMailer(true);
        // $mail = new \Mailer;
        $mail->isSMTP();
        $mail->SMTPOptions = array(
            'ssl' => array(
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            )
        );                                                // Set mailer to use SMTP
        $mail->SMTPAuth = true;
        $mail->Host = env('MAIL_HOST');                                 // Specify main and backup SMTP servers
        $mail->Username = env('MAIL_USERNAME');                           // SMTP username
        $mail->Password = env('MAIL_PASSWORD');                                 // SMTP password    k
        // $mail->Host = 'mail.employmentaustralia.com.au';
        // $mail->Username = 'email@employmentaustralia.com.au';
        // $mail->Password = 'ho$a=EXW8c@[';
        // $mail->SMTPAutoTLS = true;
        $mail->SMTPSecure = 'tls';                                      // Enable TLS encryption, `ssl` also accepted
        $mail->Port = env('MAIL_PORT',587);                                              // TCP port to connect to
        // $mail->SMTPDebug = 1;                                           // Enable SMTP authentication

        
        // EMAIL FROM | format : ['email' => '', 'name' => '']
        if($emailFrom){
            if (is_array($emailFrom)){
                if (isset($emailFrom['email']) && !isset($emailFrom['name'])) {
                    $mail->setFrom($emailFrom['email']);
                }elseif (isset($emailFrom['email']) && isset($emailFrom['name'])) {
                    $mail->setFrom($emailFrom['email'], $emailFrom['name']);
                }else {
                    $mail->setFrom('email@employmentaustralia.com.au', 'EA Automations');
                }
            }else {
                if (filter_var($emailFrom, FILTER_VALIDATE_EMAIL)) {
                    $mail->setFrom($emailFrom);
                } else {
                    $mail->setFrom('email@employmentaustralia.com.au', 'EA Automations');
                }
                
            }
        }else{
            $mail->setFrom('email@employmentaustralia.com.au', 'EA Automations');
        }

        // $mail->addAddress($email_content['email']);
        // $mail->addAddress('contact@vorx.com.au');
        // $mail->addAddress($agent->email->email);

        foreach($emailsTo as $v){
            $mail->addAddress($v);
        }

        foreach($paths as $v){
            $mail->addAttachment($v);
        }

        if(count($emailsBcc) > 0){
          foreach($emailsBcc as $v){
            $mail->addBcc($v);
          }
        }

        // $mail->addBcc('admin1@eti.edu.au');
        // $mail->addBcc('xyshain@gmail.com');
        // $mail->addBcc('Elitetrainingoffice@gmail.com');

        // $mail->addCc('admission@eti.edu.au');     // Add a recipient

        /* 
          Email Template Custom structure
          $content = [
            'data' => $data // Depending on the Custom email template's dynamic text
            'custom_type' => 'questionnaire-not-eligible'
          ]
        */

        if(is_array($content) && isset($content['custom_type'])) {
          $cntnt = $content['template'];
        }else {
          $cntnt = $this->email_template($content, $subject);
        }
        
        // foreach ($request->all() as $k => $v) {
        //     if ($k != 'undefined') {
        //         $content .= $k . ' : ' . $v . '<br>';
        //     }
        // }
        
        

        $mail->isHTML(true);                                  // Set email format to HTML
        $mail->Subject = $subject;
        $mail->Body    = $cntnt;
        // dd(\Auth::user()->id);
        if (!$mail->send()) {
            // return back()->withInput()->withErrors(['status' => 'error', 'message' => 'Email was not sent...']);
            // dump($mail->ErrorInfo);
            return json_encode(['status' => 'error', 'msg' => $mail->ErrorInfo]);
        } else {
            // dd('sent');
            // $mail->copyToFolder("Sent");

            return 1;
        }
    }
    
    public function custom_template($custom_type = '', $data = []) {
      switch ($custom_type) {
        case 'questionnaire-not-eligible':
            return view('email-template.questionnaire.not-eligible', compact($data))->render();
          break;
          
        case 'questionnaire-eligible':
            return view('email-template.questionnaire.not-eligible', compact($data))->render();
          break;
        
        default:
            // return $this->email_template('');
            return 'no data';
          break;
      }
      
    }

    public function email_template($content, $subject = '', $pdf = null, $date = null)
    {

        // $date = isset($data->created_at) ? Carbon::createFromFormat('Y-m-d H:i:s', $data->created_at)->toFormattedDateString() : Carbon::now()->toFormattedDateString();
        if ($pdf) {
            $pdf = '100%';
        } else {
            $pdf = '800';
        }
        if ($date) {
            $date = Carbon::CreateFromFormat('Y-m-d H:i:s', $date)->format('d/m/Y');
        } else {
            $date = Carbon::now()->format('d/m/Y');
        }

        // Company Details
        $org = Organisation::first();
        if($org && !in_array($org->logo_img, ['', null])){
          $logo = 'storage/config/images/'.$org->logo_img;
        }else{
          $logo = 'images/logo/vorx_logo.png';
        }
        $logo_url = $logo;

        $org_name = !in_array($org->organisation_name, ['',null]) ? $org->organisation_name : 'VORX';

        return '<!DOCTYPE html>
                <html lang="en">
                  <head>
                    <meta charset="utf-8">
                    <meta http-equiv="X-UA-Compatible" content="IE=edge">
                    <meta name="viewport" content="width=device-width, initial-scale=1">
                    <title>'.$subject.'</title>
                    <style type="text/css">
                      .text-right{text-align: right;}
                      .no-padding {padding: 0;}
                      .no-margin {margin: 0;}
                      ul.rto-code {padding: none;text-align: center;margin-top: 15px;font-size: 14px;font-weight: bold;}
                      ul.rto-code li{list-style: none;display: inline;padding: 0 10px; border-right: 1px solid #363636;}
                      ul.rto-code li:last-child{border:0;}
                    </style>
                  </head>
                  <body  style="font-family: "Malgun Gothic", Arial, sans-serif; margin: 0; padding: 0; width: 100%; -webkit-text-size-adjust: none; -webkit-font-smoothing: antialiased; position: relative;background-color: #EBF0EB;">
                <div class="main-wrapper" style="padding: 20px;">
                      <table class="table-responsive" align="center" width="' . $pdf . '" style="box-shadow: 0px 0px 3px #cccccc;font-size: 14px;color: #555555;background: #fff;">
                      <tbody class="">
                        <tr>
                          <td colspan="2"><div class="clearfix" style="height:50px;"></div></td>
                        </tr>
                      <tr>
                        <td width="50%" style="">
                          <img src="' . asset($logo_url) . '" style="margin: 0 auto;display: block; width: 180px;">
                        </td>
                      </tr>
                       <tr>
                        <td colspan="2" style="padding: 0 60px;">
                        <br>
                         <p style="font-weight: bold;">' . $date . '</p>
                        </td>
                      </tr>
                      <tr>
                        <td colspan="2" style="padding: 0 60px;">
                          <h1 style="font-weight: bold;font-size: 16px;text-align: center;text-decoration: underline;">'.$subject.'</h1>
                          <br>
                         <p style="text-align:justify;">'.$content.'</p>
                            <div class="clearfix" style="height:50px;"></div>
                        </td> 
                      </tr>
                      <tr>
                        <td colspan="2" style="padding: 0 60px;">
                         <p style="text-align: center;font-size: 9px;">© '.$org_name.' 2020 </p>
                         <div class="clearfix" style="height:10px;"></div>
                        </td>
                      </tr>
                      </tbody>
                    </table>
                </div>
                  </body>
                </html>';

        // return view('email-sending.templates.warning-letter', compact('content','date','title'));
    }


    public function getResults($data = null, $file = null, $send = 0)
    {
      if($data == null) {
        $data = Questionnaire::find(17);
        $file = $data->questionnaire_attachments[0];
      }
      $r = "";

      foreach ($data['forms'] as $key => $value) {
        if(is_array($value)) {
          $r .= '<b><u>'.ucfirst(str_replace('_', ' ', $key)).'</u></b>';
          if($key == 'personal_info') {
            $r .= '<ul>';
              foreach ($data['forms'][$key] as $k => $v) {
                switch ($k) {
                  case 'date_of_birth':
                    $r .=  '<li><b>'.ucwords(str_replace('_', ' ', $k)).'</b> : '.Carbon::parse($v)->format('d/m/Y'). '</li>';
                    break;
                  case 'country':
                    $r .=  '<li><b>'.ucwords(str_replace('_', ' ', $k)).'</b> : '.$v['full_name']. '</li>';
                    break;
                  
                  default:
                  $r .=  '<li><b>'.ucwords(str_replace('_', ' ', $k)).'</b> : '.$v. '</li>';
                    break;
                }
      
              }
              $r .= '</ul>';
          }

          if($key == 'questions') {
            $r .= '<ol>';
            foreach ($value as $k => $v) {
              foreach ($v as $kk => $vv) {
                # code...
                $r .= '<li><b>'.$vv['question'].'</b> :';
                if(is_array($vv['choices'])) {
                  $r .= '<ul><li>'.$vv['answer'].'</li></ul>';
                }else {
                  switch ($vv['choices']) {
                    case 'text':
                      $r .=  '<ul><li>'.$vv['answer'].'</li></ul>';
                      break;
                    case 'textarea':
                      $r .=  '<ul><li>'.$vv['answer'].'</li></ul>';
                      break;
                    case 'date':
                      $r .=  '<ul><li>'.Carbon::parse($vv['answer'])->format('d/m/Y').'</li></ul>';
                      break;
                    case 'select':
                      if(isset($vv['type']) && $vv['type'] == 'qualification') {
                        $r .=  '<ul><li>'.($vv['answer']['qual_code'] ?? ''). ' - '. ($vv['answer']['qual_title'] ?? '').'</li></ul>';
                      }
                      break;
                  }
                }
              }
            }
            $r .= '</ol>';
          }

          if($key == 'visa_application') {
            $r .= '<ul>';
            foreach ($value as $k => $v) {
              $r .= '<li> <b>'.$v['content'].'</b><ul><li>';
              $r .= $v['checked'] ? 'Checked' : 'Not Checked';
              $r .= '</li></ul>';
            }

            $r .= '</ul>';
          }
            
        }
        // break;
      }

      if($send == 1) {
        $path = storage_path().'/'.$file['path'].'/'.$file['name'];
        $this->send_automate('Online Questionnaire Results of '. $data['client_name'], ['custom_type' => 1, 'template' => $r], 'online@employmentaustralia.com.au', ['online@employmentaustralia.com.au'], [$path], []);
        return true;
      }else {
        return view('test.html', compact('r'));
      }
      
    }
}
