<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Send\EmailSendingController;
use App\Models\AgentDetail;
use App\Models\Deal;
use App\Models\DealSource;
use App\Models\DealStatus;
use App\Models\DealType;
use Illuminate\Http\Request;
use Carbon\Carbon;

// VORX RTO MODELS


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Illuminate\Support\Facades\File;
use PhpOffice\PhpSpreadsheet\RichText\RichText;

class ReportsController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $sources = DealSource::all()->pluck('source_name', 'id');
        $types = DealType::all()->pluck('type', 'id');
        $dealStatuses = DealStatus::all()->pluck('status_name', 'id');
        // if(\Auth::user()->hasRole('Demo')){
        //     $courses =  Course::where('user_id', \Auth::user()->id)->get()->pluck('name','code');
        // }else{
        //     $courses =  Course::all()->pluck('name','code');
        // }
        $sources['*'] = 'All Sources';
        $types['*'] = 'All Types';
        $dealStatuses['*'] = 'All Statuses';
        
        // $agents = AgentDetail::all()->pluck('agent_name', 'id');
        // $agents[0] = 'No Agent'; 
        // $agents['^'] = 'All Agents'; 
        // $agents['*'] = 'All Agents and No Agent'; 

        // $statuses = OfferLetterStatus::all()->pluck('description', 'id');
        // $statuses['*'] = 'All Status';
        
        \JavaScript::put([
            'statuses' => $dealStatuses,
            'sources' => $sources,
            'types' => $types,
            'agents' => [],
        ]);

        return view('reports.lists');
    }

    public function list_generator(Request $request)
    {
        // dd($request->all());

        if(count($request->clients) == 0){
            return ['status' => 0];
        }

        $clients = $request->clients;


        $headers = array_keys($clients[0]);

        $path = storage_path('app/excel');
        File::makeDirectory($path, $mode = 0777, true, true);

        // dd($path);

        $spreadsheet = new Spreadsheet();
        $spreadsheet->getDefaultStyle()->getFont()->setSize(11);
        $sheet = $spreadsheet->getActiveSheet();

        

        $richTitle = new RichText();
        $title = 'Client List ( '. Carbon::createFromFormat('Y-m', $request->from)->format('M Y') . ' - '. Carbon::createFromFormat('Y-m', $request->to)->format('M Y'). ' )'; 
        $titleBolds = $richTitle->createTextRun($title);
        $titleBolds->getFont()->setBold(true)->setSize(26);
        // dump($richTitle);
        $sheet->setCellValue('A1', $richTitle);

        // headers
        $letter = 'A';
        foreach ($headers as $item){
            // $itm = $richText->createTextRun($item)->getFont()->setBold(true);
            $spreadsheet->getActiveSheet()->getColumnDimension($letter)->setAutoSize(true);
            $richText = new RichText();
            $bolds = $richText->createTextRun($item);
            $bolds->getFont()->setBold(true)->setSize(12);
            // dump($richText);
            $sheet->setCellValue($letter.'3', $richText);
            $letter++;
        }

        // Merge for Title
        $sheet->mergeCells('A1:'.$letter.'1');

        // body
        $number = 4;
        // for ($number = 1 ; count($clients) > $number ; $number++){
        foreach ($clients as $item){
            $letter = 'A';
            foreach ($item as $v){
                $var = $letter.''.$number;
                $sheet->setCellValue($var, $v);
                $letter++;
            }
            $number++;
        }
        // }
        
        
        $writer = new Xlsx($spreadsheet);
        
        $f = $path.'/Client List.xlsx';

        $writer->save($f);

        // dd('exported');

        return [
            'status' => 1,
            'file' => 'Client List.xlsx',
            'rename' => 'Client List '. Carbon::createFromFormat('Y-m', $request->from)->format('M Y') . ' - '. Carbon::createFromFormat('Y-m', $request->to)->format('M Y'). '.xlsx'
        ];
        
        
        // header("Content-type: application/xls");
        // header('Content-Disposition: attachment; filename=Student_List.xls');
        // header("Pragma: no-cache"); 
        // header("Expires: 0");

        // dd('test');

        // $output = fopen("php://output", "w");
        // $header = array_keys($stud[0]);
        // fputcsv($output, $header);

        // foreach ($clients as $value) {

            

            // fputcsv($output, [
            //     'Serial No.' => $hosp['org_details']['serial_no'],
            //     'Hospital' => $hosp['party']['name'],
            //     'Category' => $hosp['org_details']['category_type'],
            //     'Director' => $reps,
            //     'Address' => $address,
            //     'Email' => $hosp['org_details']['email'],
            //     'Telephone' => $hosp['org_details']['tel_no'],
            //     'Fax' => $hosp['org_details']['fax']
            // ]);

            // fputcsv($output, $value);
            

        // }
        // fclose($output);


        // dd($clients);
        //
        // return view('reports.lists');
    }

    public function download($type,$file,$rename)
    {

        $path = storage_path('app/'.$type);

        $f = $path.'/'.$file;

        // dd($f);

        $filetype=filetype($f);
        $filename=basename($f);
        header ("Content-Type: ".$filetype);
        header ("Content-Length: ".filesize($f));
        header ("Content-Disposition: attachment; filename=".$rename);

        readfile($f);
    }
    

    public function client_list(Request $request)
    {
        
        // if(!isset($request->automate) && \Auth::user()->hasRole('Demo')){
        //     // $students = Student::where('user_id', \Auth::user()->id)->where('student_type_id', $request->student_type)->get();
        //     $students = Student::where('user_id', \Auth::user()->id)->where('student_type_id', $request->student_type)->get();
        // }else{
        //     // $students = Student::where('student_type_id', $request->student_type)->get();
        //     $students = Student::where('student_type_id', $request->student_type == '*' ? '!=' : '=', $request->student_type)->get();
        // }
        // dump($request->all());
        // dump(Carbon::createFromFormat('Y-m', $request->from)->format('Y-m-01'));
        // dump(Carbon::createFromFormat('Y-m', $request->to)->format('Y-m-t'));

        // $source = $request->get_source == '*' ? '!=' : '=';

        $deals = Deal::with(['deal_type', 'convos','notes','deal_source','deal_status','party.person.contact_detail.country', 'client_detail.nationality', 'client_detail.visa_status', 'client_detail.assigned.party', 'client_detail.referrer.deal.party.person.contact_detail', 'invoices.payments.user.party', 'invoices.invoice_details'])
                ->whereBetween('active_date', [Carbon::createFromFormat('Y-m', $request->from)->format('Y-m-01'), Carbon::createFromFormat('Y-m', $request->to)->format('Y-m-t')]);
                // ->where('deal_type_id', $request->deal_type == '*' ? '!=' : '=', $request->deal_type)
                // ->where('deal_status_id', $request->get_status == '*' ? '!=' : '=', $request->get_status)
                
        if($request->get_source != '*'){
            $deals->where('deal_source_id', '=', $request->get_source);
        }
        if($request->get_status != '*'){
            $deals->where('deal_status_id', '=', $request->get_status);
        }
        if($request->deal_type != '*'){
            $deals->where('deal_type_id', '=', $request->deal_type);
        }
        
        // $deals->get();
        $deals = $deals->get();

        // dump($students->toArray());
        $clients = [];
        
        if(!isset($request->from)){
            return $clients;
        }
        // dump($request->from.'-01');
        // dd(date($request->to.'-t'));
        // dd($request->all());

        // agent filter
        // $agent = $request->get_agent == '0' ? null : $request->get_agent;
        
        // if($request->student_type == 2){
            foreach($deals as $item){
                $convo_list = [];
                $note_list = [];

                if(count($item->convos) > 0){
                    foreach($item->convos as $con){
                        $convo_list[] = $this->get_data($con->note_date, 'datetime').' - '.$con->remarks;
                    }
                }
                if(count($item->notes) > 0){
                    foreach($item->notes as $note){
                        $note_list[] = $this->get_data($note->note_date, 'datetime').' - '.$note->remarks;
                    }
                }

                $clients[] = [
                    'Client ID' => $item->client_detail->customer_id,
                    'Full Name' => $item->party->name,
                    'Deal Type' => $item->deal_type->type,
                    'Deal Source' => isset($item->deal_source->source_name) ? $item->deal_source->source_name : '',
                    'Date of Birth' => $this->get_data($item->party->person->date_of_birth, 'date'),
                    'Email Address' => $item->party->person->contact_detail->email,
                    'Alternative Email' => $item->party->person->contact_detail->email_alt ?? '',
                    'Phone # 1' => isset($item->party->person->contact_detail->phones[0]) ? $this->get_data($item->party->person->contact_detail->phones[0]) : null,
                    'Phone # 2' => isset($item->party->person->contact_detail->phones[1]) ? $this->get_data($item->party->person->contact_detail->phones[1]) : null,
                    'Phone # 3' => isset($item->party->person->contact_detail->phones[2]) ? $this->get_data($item->party->person->contact_detail->phones[2]) : null,
                    'Address' => $item->party->person->contact_detail->address_1,
                    'State' => $item->party->person->contact_detail->state,
                    'Postcode' => $item->party->person->contact_detail->postcode,
                    'Country' => isset($item->party->person->contact_detail->country->full_name) ? $item->party->person->contact_detail->country->full_name : null,
                    '5th Call' => $item->client_detail->fifth_call == 1 ? 'Yes' : 'No',
                    'Nationality' => isset($item->client_detail->nationality->nationality) ? $item->client_detail->nationality->nationality : null,
                    'Visa Status' => isset($item->client_detail->visa_status->visa) ? $item->client_detail->visa_status->visa : null,
                    'Expiration Date' => isset($item->client_detail->expiration_date) ? $this->get_data($item->client_detail->expiration_date, 'date') : null,
                    'Passport' => isset($item->client_detail->passport) ? $this->get_data($item->client_detail->passport) : null,
                    'College Currently Enroled' => isset($item->client_detail->college_currently_enroled) ? $this->get_data($item->client_detail->college_currently_enroled) : null,
                    'Client Member Card No.' => isset($item->client_detail->client_member_card_no) ? $this->get_data($item->client_detail->client_member_card_no) : null,
                    'Referrer' => isset($item->client_detail->referrer->deal->party->name) ? $this->get_data($item->client_detail->referrer->deal->party->name) : null,
                    'Assigned To' => isset($item->client_detail->assigned->party->name) ? $this->get_data($item->client_detail->assigned->party->name) : null,
                    // 'Last Convo' => isset($item->convos[0]) ? $item->convos[0]->remarks : '',
                    'Date Created' => $this->get_data(Carbon::parse($item->created_at)->format('Y-m-d'), 'date'),
                    'Conversation' => implode("\r\n \r\n", $convo_list),
                    'Note' => implode("\r\n \r\n", $note_list),
                    
                ];
                // dd($clients);
            }
                    
                
            
        // }else{
            // dd($clients);
            // foreach($students as $stud){
            //     foreach($stud->completion as $com){
                    
            //     }
            // }
            // $clients = [];
        // }
        // dd($clients);

        return $clients;
    }

    public function get_data($data, $type = 'text')
    {
        $data = !in_array($data, ['', null]) ? $data : null;

        if($data != null){
            switch ($type) {
                case 'date':
                    $data = Carbon::createFromFormat('Y-m-d', $data)->format('d/m/Y');
                    break;
    
                case 'int':
                    $data = intval($data);
                    break;
                
                case 'datetime':
                    $data = Carbon::createFromFormat('Y-m-d H:i:s', $data)->format('d/m/Y h:i:s A');
                    break;
    
            }
        }
        return $data;
    }

    public function send_course_progress(Request $request)
    {
       
    }

    public function generate_pdf($filter){

        // dd($filter);
        $fil = json_decode($filter);
        $deals = Deal::with(['deal_type', 'convos','notes','deal_source','deal_status','party.person.contact_detail.country', 'client_detail.nationality', 'client_detail.visa_status', 'client_detail.assigned.party', 'client_detail.referrer.deal.party.person.contact_detail', 'invoices.payments.user.party', 'invoices.invoice_details'])->whereBetween('active_date', [Carbon::createFromFormat('Y-m', $fil->from)->format('Y-m-01'), Carbon::createFromFormat('Y-m', $fil->to)->format('Y-m-t')]);
        // ->where('deal_type_id', $fil->deal_type == '*' ? '!=' : '=', $fil->deal_type)
        // ->where('deal_status_id', $fil->get_status == '*' ? '!=' : '=', $fil->get_status)
        
        if($fil->get_source != '*'){
            $deals->where('deal_source_id', '=', $fil->get_source);
        }
        if($fil->get_status != '*'){
            $deals->where('deal_status_id', '=', $fil->get_status);
        }
        if($fil->deal_type != '*'){
            $deals->where('deal_type_id', '=', $fil->deal_type);
        }

        $clients = $deals->get();
     
        if(count($clients) == 0){
            abort(403, 'No records available...');
        }

        $path = storage_path('app/pdf');
        if (!File::isDirectory($path)) {
            File::makeDirectory($path, $mode = 0777, true, true);
        }
        
        // $filename = $client->client_detail->customer_id. ' - '. $client->party->name . '.pdf';
        // dd($clients);
        // \PDF::loadView('reports.client-list-pdf', compact('clients'))->setPaper(array(0, 0, 794, 1122), 'portrait')->save($path.'/Client List.pdf')->stream('Client List.pdf');

        return \PDF::loadView('reports.client-list-pdf', compact('clients'))->setPaper(array(0, 0, 794, 1122), 'portrait')->stream('Client List '. Carbon::createFromFormat('Y-m', $fil->from)->format('M Y') . ' - '. Carbon::createFromFormat('Y-m', $fil->to)->format('M Y'). '.pdf');
    }

}
