<?php

namespace App\Http\Controllers\Online\Ea;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Send\EmailSendingController;
use App\Models\AvtCountryIdentifier;
use App\Models\EmailAutomation;
use App\Models\QualificationClassification;
use App\Models\Questionnaire;
use App\Models\QuestionnaireAttachment;
use Illuminate\Http\Request;

class OnlineController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $q = $this->get_questionnaires('ID');
        $country = AvtCountryIdentifier::all();
        
        \JavaScript::put([
            'countries' => $country,
            'questions' => $q['questions'],
            'visa_application' => $q['visa_application'],
            'img' => $q['img'],
            'loc' => 'PH',
        ]);

        return view('online.ea.index');
    }

    public function get_questionnaires($loc) 
    {
        /* 
            AUTOMATED REPLY
            - 0 => Not Eligible
            - 1 => Contact us Directly
            - 2 => Contact us via email
            - 3 => Contact us for further information  
        */

        $loc = strtoupper($loc);

        $locations = [
            'ID' => [
                'img'  => '/images/online/image-2.png',
                'fees'  => [
                    'forSixMonths' => 'IDR 50000000',
                    'ahc'  => 'IDR 6984450',
                    'osh'  => 'IDR 10543202'
                ]
            ],
            'PH' => [
                'img'  => '/images/online/image-1.png',
                'fees'  => [
                    'forSixMonths' => 'PHP 167,909',
                    'ahc'  => 'PHP 25173.47',
                    'osh'  => 'PHP 36,270'
                ]
            ],
        ];
        
        if(!isset($locations[$loc]['img'])) {
            return abort(404);
        }
        $questions = [
            [
                [
                    'question' => 'Are you 18 years old and above not exceeded 35 years old?',
                    'choices' => ['Yes', 'No'],
                    'answer' => 'No',
                    'auto' => ['No' => 0]
                ],
                [
                    'question' => 'What is your Martial Status?',
                    'choices' => ['Married', 'Single'],
                    'answer' => 'Single',
                    'auto' => ['Married' => 3]
                ],

                [
                    'question' => 'Do you have a current Passport?',
                    'choices' => ['Yes', 'No'],
                    'answer' => 'No',
                    'auto' => ['No' => 2]
                ],

                [
                    'question' => 'Which Country?',
                    'choices' => 'text',
                    'answer' => null,
                ],

                [
                    'question' => 'What is your passport Expiry Date? (DD/MM/YYYY)',
                    'choices' => 'date',
                    'answer' => null,
                ],

                [
                    'question' => 'What is your VISA subclass?',
                    'choices' => 'text',
                    'answer' => null,
                ],

                [
                    'question' => 'What is your visa expiry date? (DD/MM/YYYY)',
                    'choices' => 'date',
                    'answer' => null,
                ],

                [
                    'question' => 'When did you arrive in Australia? (DD/MM/YYYY)',
                    'choices' => 'date',
                    'answer' => null,
                ],
            ],
            [
                [
                    'question' => 'Have you applied for any visa in any country?',
                    'choices' => ['Yes', 'No'],
                    'answer' => 'No',
                ],
                [
                    'question' => 'Has your visa ever been rejected?',
                    'choices' => ['Yes', 'No'],
                    'answer' => 'No',
                    'auto' => ['Yes' => 0]
                ],
                [
                    'question' => 'If yes which country',
                    'choices' => 'text',
                    'answer' => null,
                ],
                [
                    'question' => 'Did you have your visa canceled?',
                    'choices' => ['Yes', 'No'],
                    'answer' => 'No',
                    'auto' => ['Yes' => 0]
                ],
                [
                    'question' => 'What is your Highest Qualification?',
                    'choices' => 'text',
                    'answer' => null,
                ],
                [
                    'question' => 'What year did you finish your highest Qualification?',
                    'choices' => 'text',
                    'answer' => null,
                ],
                [
                    'question' => 'Did you have English Language Test?',
                    'choices' => ['Yes', 'No'],
                    'answer' => 'No',
                ],
                [
                    'question' => 'Are you currently Studying?',
                    'choices' => ['Yes', 'No'],
                    'answer' => 'No',
                ],
                [
                    'question' => 'If yes, Which qualification?',
                    'choices' => 'select',
                    'answer' => null,
                    'type' => 'qualification',
                    'options' => QualificationClassification::all(),
                ],
            ],
            [
                [
                    'question' => 'Notes (if any)',
                    'choices' => 'textarea',
                    'answer' => "Type your thoughts here...",
                ],
                // [
                //     'question' => 'Attach your detailed resume here',
                //     'choices' => 'text',
                //     'answer' => null,
                // ],
            ]
        ];
        // $questions = [
        //     [
        //         'question' => 'Are you 18 years old and above not exceeded 35 years old?',
        //         'choices' => ['Yes', 'No'],
        //         'answer' => 'No',
        //         'auto' => ['No' => 0]
        //     ],
        //     [
        //         'question' => 'What is your Martial Status?',
        //         'choices' => ['Married', 'Single'],
        //         'answer' => 'Single',
        //         'auto' => ['Married' => 3]
        //     ],

        //     [
        //         'question' => 'Do you have a current Passport?',
        //         'choices' => ['Yes', 'No'],
        //         'answer' => 'No',
        //         'auto' => ['No' => 2]
        //     ],

        //     [
        //         'question' => 'Which Country?',
        //         'choices' => 'text',
        //         'answer' => null,
        //     ],

        //     [
        //         'question' => 'What is your passport Expiry Date?',
        //         'choices' => 'text',
        //         'answer' => null,
        //     ],

        //     [
        //         'question' => 'What is your VISA subclass?',
        //         'choices' => 'text',
        //         'answer' => null,
        //     ],

        //     [
        //         'question' => 'What is your visa expiry date?',
        //         'choices' => 'text',
        //         'answer' => null,
        //     ],

        //     [
        //         'question' => 'When did you arrive in Australia?',
        //         'choices' => 'text',
        //         'answer' => null,
        //     ],

            

        //     [
        //         'question' => 'Do you have a current Passport and wanted to study in Australia?',
        //         'choices' => ['Yes', 'No'],
        //         'answer' => 'No',
        //         'auto' => ['No' => 2]
        //     ],
        //     [
        //         'question' => 'Have you applied for any visa in any country?',
        //         'choices' => ['Yes', 'No'],
        //         'answer' => 'No',
        //     ],
        //     [
        //         'question' => 'Has your visa ever been rejected?',
        //         'choices' => ['Yes', 'No'],
        //         'answer' => 'No',
        //         'auto' => ['Yes' => 0]
        //     ],
        //     [
        //         'question' => 'Did you have your visa canceled?',
        //         'choices' => ['Yes', 'No'],
        //         'answer' => 'No',
        //         'auto' => ['Yes' => 0]
        //     ],
        //     [
        //         'question' => 'What is your Highest Qualification?',
        //         'choices' => 'text',
        //         'answer' => null,
        //     ],
        //     [
        //         'question' => 'What year did you finish your highest Qualification?',
        //         'choices' => 'text',
        //         'answer' => null,
        //     ],
        //     [
        //         'question' => 'Did you have English Language Test?',
        //         'choices' => ['Yes', 'No'],
        //         'answer' => 'No',
        //     ],
        //     [
        //         'placeholder' => 'If yes, please indicate score and year taken',
        //         'choices' => 'text',
        //         'answer' => null,
        //     ],
        //     [
        //         'question' => 'Do you have enough money to pay college fees approx '.$locations[$loc]['fees']['forSixMonths'].' for 6 months?',
        //         'choices' => ['Yes', 'No'],
        //         'answer' => 'No',
        //         'auto' => ['Yes' => 1]
        //     ],
        // ];

        $visa_application = [
            // [
            //     'content' => 'I agree to pay the Student VISA application fee directly to Australian High Commission for AUD $495 (Approx '.$locations[$loc]['fees']['ahc'].').',
            //     'note' => 'Note: This fee is non refundable.',
            //     'checked' => null,
            //     'auto' => ['unchecked' => 0]
            // ],
            [
                'content' => 'I agree to pay the VISA application fee directly to Australian High Commission for AUD $495.',
                'note' => 'Note: This fee is non refundable.',
                'checked' => null,
                'auto' => ['unchecked' => 0]
            ],
            // [
            //     'content' => 'I agree to pay AUD $979 (approx. '.$locations[$loc]['fees']['osh'].') for Overseas Students Healthcare before the application is lodged directly to www.ahm.com.au.',
            //     'note' => 'Note: This amount is refundable in full if the visa is not granted.',
            //     'checked' => null,
            //     'auto' => ['unchecked' => 0]
            // ],
        ];

        return [
            'questions' => $questions,
            'visa_application' => $visa_application,
            'img' => $locations[$loc]['img'],
        ];
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = json_decode($request->data, true);

        $personal_info = $data['personal_info'];
        $questions = $data['questions'];
        $visa_app = $data['visa_application'];
        $loc = strtoupper($data['location']);

        $content_type = null;

        /* 
            AUTOMATED REPLY
            - 0 => Not Eligible
            - 1 => Contact us Directly
            - 2 => Contact us via email
            - 3 => Contact us for further information  
        */

        // $autoPatterns = [ 0 => 'Not Eligible', 1 => 'Contact us Directly']
        $getAutoAnswers = [];

        // foreach ($questions as $k => $v) {
        //     if(isset($v['auto'])) {
        //         if(isset($v['auto'][$v['answer']])){
        //             $getAutoAnswers[] = $v['auto'][$v['answer']];
        //         }
        //     }
        // }

        // $autoReps = [
        //     'Not Eligible',
        //     'Contact us Directly',
        //     'Contact us via email',
        //     'Contact us for further information', 
        // ];
        
        // foreach ($getAutoAnswers as $v) {
        //     if(is_null($content_type)){
        //         $content_type = $v;
        //     }
        //     foreach ($autoReps as $key => $value) {
        //         if($content_type != $key && $v <= $key && $content_type >= $v) {
        //             $content_type = $v;
        //             break;
        //         }
        //     }
        // }
        
        // $content_type = $autoReps[$content_type];
        $content_type = 'general response';
        $selected_content = $this->select_content($content_type, $personal_info);

        $send = new EmailSendingController;
        $email_to = ['email'=>'online@employmentaustralia.com.au', 'name'=>'EA Online Questionnaire'];

        // $bcc = EmailAutomation::where('addOn', 'questionnaire')->get()->pluck('email');
        // $bcc = isset($bcc[0]) ? $bcc->toArray() : [];
        $bcc = [];

        $content = '';

        switch ($loc) {
            case 'ID':
                $content = view('email-template.questionnaire.eligibility', ['content' => $selected_content['content']])->render();
                break;
            case 'PH':
                $content = view('email-template.questionnaire.eligibility-ph', ['content' => $selected_content['content']])->render();
                break;
            
            default:
                # code...
                break;
        }
        
        
        $checkSend = $send->send_automate($selected_content['subject'], ['custom_type' => 1, 'template' => $content], $email_to, [$selected_content['email']], [], $bcc);
        // $checkSend = $send->send_automate($selected_content['subject'], ['custom_type' => 1, 'template' => $content], $email_to, ['jim@you1st.com.au', 'constant.claro@gmail.com'], [], []);
        $checkSend = 1;
        if ($checkSend == 1) {
            

            // remove qualification option
            foreach ($data['questions'][1] as $key => $val) {
                if(isset($val['type']) && $val['type'] == 'qualification') {
                    $data['questions'][1][$key]['options'] = [];
                }
            }

            // save questionnaire
            $q = new Questionnaire([
                'process_id' => $this->codeNumber(),
                'client_name' => $selected_content['fullname'],
                'forms' => $data,
            ]);
            $q->save();

            if($request->file('file')) {
                // save attachment
                $file = $request->file('file');
                $path = $file->storeAs('public/questionnaires/attachments/'.$q->id, $selected_content['fullname'] .' - Detailed Resume.'.$file->guessClientExtension());
                
                $att = new QuestionnaireAttachment([
                    'name' => $selected_content['fullname'] .' - Detailed Resume.'.$file->guessClientExtension(),
                    'has_name' => $selected_content['fullname'] .' - Detailed Resume',
                    'path' => 'app/public/questionnaires/attachments/'.$q->id,
                    'size'      => $file->getClientSize(),
                    'mime_type' => $file->getMimeType(),
                    'ext'       => $file->guessClientExtension(),
                    '_input'       => 'detailed_resume',
    
                ]);
                $att->questionnaire()->associate($q);
                $att->save();
            }


            // send data to online@employmentaustralia.com.au
            $send->getResults($q, $att, 1);


            return ['status' => 'success'];
        }else{
            return ['status' => 'error'];
        }

        // dump($content_type);
        // dd('end');


    }

    public function select_content($type = '', $info)
    {
        $subject = 'Eligibility Check';
        $content = '';
        $full_name = $info['firstname']. ' ' .$info['lastname'];
        $email = $info['email'];
        
        switch ($type) {
            case 'Not Eligible':
                    $content = 'Dear '.$full_name. ',<br><br>We are sorry to tell you that you are not eligible to be a student in Australia.<br><br>Sincerely,<br>Kaur Migration Team';
                    $type = 'not-eligible';
                break;
            case 'Contact us Directly':
                    $content = 'Dear '.$full_name. ',<br><br>We are happy to announce that you are eligible to be a student in Australia. Please contact us directly using this following hotline XXXX-XXX-XXXX.<br><br>We hope to hear from you soon.<br><br>Sincerely,<br>Kaur Migration Team';
                    $type = 'eligible';
                break;
            case 'Contact us via email':
                    $content = 'Dear '.$full_name. ',<br><br>We are happy to announce that you are eligible to be a student in Australia. Please contact us through our email address admin@kaurmigration.com.au.<br><br>We hope to hear from you soon.<br><br>Sincerely,<br>Kaur Migration Team';
                    $type = 'eligible';
                break;
            case 'Contact us for further information':
                    $content = 'Dear '.$full_name. ',<br><br>We scanned your information and answers from you questionnaire. With these, we would like you to contact us through our email address admin@kaurmigration.com.au or give us a call with the following hotline XXXX-XX-XXXX.<br><br>We hope to hear from you soon.<br><br>Sincerely,<br>Kaur Migration Team';
                    $type = 'eligible';
                break;
            case 'general response':
                    $content = 'We thank you for showing your Trust in <b>Employment Australia</b>.<br><br>Our Passion is your Success.<br><br>Every team member is committed in getting you the best possible outcome. We will be in contact with you within 5 working days to dissuss your application further.';
                break;
        }
       
        // if($type == 'eligible') {
        //     $content = '<p>Welcome to <b style="color: #ef542c;">Kaur Migration!</b></p>
        //     <div class="clearfix" style="height:15px;"></div>
        //     <p>I\'m so excited to inform you that you are <b>Eligible</b> for our offer to study in Australia.</p>
        //     <div class="clearfix" style="height:15px;"></div>
        //     <p>Please make your email and phone line open within 1-2 days and expect our call for your next step. Congratulations!</p>';
        // }else {
        //     $content = '<p>Welcome to <b style="color: #ef542c;">Kaur Migration!</b></p>
        //     <div class="clearfix" style="height:15px;"></div>
        //     <p>Sorry to inform you that you <b>did not meet one of our Eligibility Criteria at this time</b>. If your circumstances change, you can again try and recheck your eligibility below.</p>
        //     <div class="clearfix" style="height:15px;"></div>
        //     <a href="https://crm.kaurmigration.com/online-questionnaire/" target="_blank" style="display: inline-block;"><img src="http://kaurmigration.com.au/files/email/eligibility-check-btn.png" alt="Eligibility Check"></a>
        //     <div class="clearfix" style="height:15px;"></div>
        //     <p>If you have questions, please send us an email at id@kaurmigration.com and we will be happy to answer your queries.</p>';
        // }

        return [
            'subject' => $subject,
            'content' => $content,
            'fullname' => $full_name,
            'email' => $email,
            'type' => $type,
            'custom' => 1,
        ];
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
        $q = $this->get_questionnaires($id);
    
        \JavaScript::put([
            'countries' => AvtCountryIdentifier::all(),
            'questions' => $q['questions'],
            'visa_application' => $q['visa_application'],
            'img' => $q['img'],
            'loc' => $id,
        ]);

        return view('online.questionnaire.index');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function codeNumber()
    {
        $number = mt_rand(000000001, 999999999);

        $number = sprintf("%09d", $number);

        if (count($this->codeNumberExist($number))) {
            return $this->codeNumber();
        }

        return $number;
    }
    public function codeNumberExist($number)
    {
        return Questionnaire::where('process_id', $number)->get();
    }

}
