<?php

namespace App\Http\Controllers\Master;

use App\Http\Controllers\Controller;
use App\Models\ClientDetail;
use App\Models\ContactDetail;
use App\Models\Deal;
use App\Models\DealAttachment;
use App\Models\DealAttachmentFolder;
use App\Models\DealNote;
use App\Models\DealSource;
use App\Models\DealType;
use App\Models\Invoice;
use App\Models\InvoiceDetail;
use App\Models\Organisation;
use App\Models\Party;
use App\Models\Payment;
use App\Models\PaymentDetail;
use App\Models\Person;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class ConvertMasterController extends Controller
{
    //

    private $connect = 'crmv3';

    public function convert()
    {

        $deals = DB::connection($this->connect)->table('deals')->where('accounts_id', 4)
                    // ->join('party', 'party.id', '=', 'deals.party_id')
                    // ->limit(10)
                    ->get();


        // dd($deals);

        $counter = 0;
        
        foreach ($deals as $key => $value) {
            // print_r ('------------------------------------------');
            

            // dump('run');

            // create client - deals
            $d = $this->create_deal($value);

            // $n = $this->create_notes($d);

            // dump($d);
            if(isset($d['status']) && in_array($d['status'], ['success', 'existed'])) {
                print ('Client Name : '. $d['deal']->party->name . ' -> ');
                
                // create deal notes
                $n = $this->create_notes($d);

                // create deal attachments
                // $a = $this->create_attachments($d);

                // create deal invoice payments
                $i = $this->create_invoice_payments($d['deal']);
                // dd($n);
                // dump('------------------------------------------');
                // $counter++;
            }

            if($counter == 10){
                break;
            }


        }
        
        echo 'done';
        // dd($deals[2060]);
    }

    public function getQueries()
    {
        $q = DB::connection($this->connect)->table('query')
                    // ->join('query_comment', 'query_comment.query_id', '=', 'query.id')
                    // ->limit(10)
                    ->get();

        foreach ($q as $k => $v) {

            $contact = $v->contact_number;

            // remove spaces and dash (-)
            $contact = str_replace(' ', '', $contact);
            $contact = str_replace('-', '', $contact);

            // replace +64 to 0
            $contact = str_replace('+64', '0', $contact);

            // dump(intval($contact));
            // dump($contact);

            if(intval($contact) != 0){
                $con_dets = ContactDetail::with(['person.party.deal'])->where('phones', 'like', '%'.$contact.'%')->first();

                if(!$con_dets) {
                    print(' <-> create - '. $v->client_name);

                    // get latest old_deals_id;
                    $latest_old_deal_id = Deal::max('old_deal_id');

                    // create deal source if not existed
                    $dealSource = DealSource::where('source_name', $v->category)->first();
                    if(!$dealSource) {
                        $dealSource = new DealSource;
                        $dealSource->source_name = $v->category;
                        $dealSource->save();
                    }

                    // dd();
                    try {

                        $party = new Party;
                        $person = new Person;
                        $contact_detail = new ContactDetail;
                        $deal = new Deal;
                        $client_detail = new ClientDetail;
            
                        DB::beginTransaction();
                        $party->fill([
                            'party_type_id'    => 1,
                            'name'          => preg_replace('/\s+/', ' ', $v->client_name),
                            // 'active'        => 1
                        ]);
            
                        $party->save();
            
                        $person->fill([
                            'firstname'     => preg_replace('/\s+/', ' ', $v->client_name),
                            'person_type_id'   => 5
                        ]);
                        $person->party()->associate($party);
                        $person->save();
            
                        // phone 1
                        $phones = [];
                        $phones[] = $contact;
                        
            
                        $contact_detail->fill([
                            'phones' => count($phones) > 0 ? $phones : null,
                        ]);
                        $contact_detail->person()->associate($person);
                        $contact_detail->save();
                        
                        $deal->fill([
                            'deal_type_id' => 1,
                            'old_deal_id' => ++$latest_old_deal_id,
                            'deal_source_id' => $dealSource->id,
                        ]);
                        $deal->party()->associate($party);
                        $deal->user()->associate(User::find(31));
                        $deal->created_at = $v->created_at;
                        $deal->active_date = Carbon::parse($v->created_at)->format('Y-m-d');
                        $deal->save();
                        
                        $c_id = $this->generate_customer_id();
                        // dump($c_id);
                        $client_detail->fill([
                            'customer_id' => $c_id
                            // 'assigned_to'               => isset($migration_applications->'assigned']['id']) ? $migration_applications->'assigned']['id'] : null,
                        ]);
                        $client_detail->deal()->associate($deal);
                        $client_detail->save();
            
                        // update client_detail_id in contact_details table
                        $contact_detail->client_detail()->associate($client_detail);
                        $contact_detail->update();
            
                        DB::commit();
            
                        // return ['status' => 'success', 'deal' => $deal->id, 'customer_id' => $client_detail->customer_id];
                        // return ['status' => 'success', 'deal' => $deal, 'customer_id' => $client_detail->customer_id];
            
                    } catch (\Throwable $th) {
                        DB::rollback();
                        // return ['status' => 'error', 'msg' => $th];
                        // return ['status' => 'error', 'msg' => $th];
                        dd($th);
                    }



                }else{
                    print(' <-> existed - '. $v->client_name);
                    $deal = $con_dets->person->party->deal; 
                }
                
                if($deal->convos->count() == 0) {
                    $q_com = DB::connection($this->connect)->table('query_comment')->where('query_id', $v->id)->get();
                    if($q_com->count() > 0) {
                        foreach ($q_com as $kk => $vv) {
                            // $check_com = DealNote::where('old_deal_id', $deal->old_deal_id)->where('remarks', 'like', '%'.$vv->remarks.'%')->first();
                            $check_com = DealNote::where('id', $deal->id)->where('old_note_id', $vv->id)->first();

                            if(!$check_com) {
                                $check_com = new DealNote;
                                $check_com->fill([
                                    'note_type' => $vv->note_type,
                                    'remarks' => $vv->remarks,
                                    'old_note_id' => $vv->id,
                                ]);
                                $check_com->note_date = $vv->created_at;
                                $check_com->user()->associate(User::find(31));
                                $check_com->deal()->associate($deal);
                                $check_com->save();

                                print(' -> created : '.$check_com->id);
                            }else{
                                print(' -> existed: '. $check_com->id);
                            }

                        }
                    }
                }
            }


            // dump($con_dets);
            // dd($v);
        }

        print('end');
    }

    public function getAttachments()
    {
        $attachments = DealAttachment::with(['deal.party.person'])->whereNull('path')->where('no_attachment', 0)->get();

        print ('TOTAL ATTACHMENTS LEFT : '. $attachments->count() .' ---> ');
        // dd($attachments[0]);
        foreach ($attachments as $k => $v) {
            # code...
            $this->create_attachments(['status'=>'success', 'deal'=>$v->deal], $v);
        }
    }

    public function convert_users()
    {
        $users = DB::connection($this->connect)->table('users')->where('primary_account_id', 4)
                    ->join('party', 'party.id', '=', 'users.party_id')
                    ->select([
                        'users.id as user_id',
                        'party.id as party_id', 
                        'party.name', 
                        'users.firstname',
                        'users.lastname',
                        'users.email',
                        'users.password',
                        'users.remember_token',
                        'users.login_name',
                        'users.location',
                        ])
                    ->get();

        // dd($users[0]);

        foreach ($users as $key => $value) {
            $u = User::where('old_user_id', $value->user_id)->first();

            if(!$u) {
                $u = new User;
                $p = new Party;
                $pp = new Person;

                $p->fill([
                    'party_type_id'    => 1,
                    'name'          => preg_replace('/\s+/', ' ', $value->firstname . ' ' . $value->lastname)
                ]);
                $p->save();
    
                $pp->fill([
                    'person_type_id' =>  1,
                    'firstname'   => $value->firstname,
                    'lastname'    => $value->lastname,
                ]);
                $pp->party()->associate($p);
                $pp->save();
    
    
                // $password = Hash::make($request->password);
                $u->fill([
                    'username'      => $value->login_name,
                    'old_user_id'   => $value->user_id,
                    'password'      => $value->password,
                    'email'         => $value->email,
                    'location'         => $value->location,
                    'is_active'     => 1,
                    'profile_image' => 'default-profile.png'
                ]);
                $u->party()->associate($p);
                $u->save();
    
                $u->assignRole('Staff');

            }

            dump($u->username);

        }

        dd('done');
    }

    public function create_deal($data)
    {
        // dd($data);
        $ifExist = Deal::where('old_deal_id', $data->id)->first();

        if($ifExist) {

            $migration_applications = DB::connection($this->connect)->table('migration_applications')->where('deal_id', $data->id)->first();
            
            $user = User::where('old_user_id', $migration_applications->assigned_to)->first();
            $u = User::where('old_user_id', $data->user_id)->first();

            // if($ifExist->deal_type_id == 1) {
            //     $ifExist->deal_type()->associate(DealType::find(2));
            //     $ifExist->update();
            // }
            $att = $ifExist->attachments;

            if($ifExist->attachments->count() < 1) {
                $ifExist->deal_type()->associate(DealType::find(1));
                $ifExist->update();
            }

            if($ifExist->user_id == null && $u) {
                $ifExist->user()->associate($u);
                $ifExist->update();
            }
            if($ifExist->client_detail->assigned_to == null){
                $ifExist->client_detail->client_member_card_no = $migration_applications->membership_card_no;
                $ifExist->client_detail->assigned()->associate($user);
                $ifExist->client_detail->update();
            }

            if($ifExist->deal_status_id == null) {
                $ifExist->deal_status_id = $data->deal_status_id;
                $ifExist->update();
            }

            if($ifExist->active_date == null) {
                $ifExist->active_date = Carbon::parse($data->created_at)->format('Y-m-d');
                $ifExist->update();
            }

            return ['status' => 'existed', 'deal' => $ifExist, 'customer_id' => $ifExist->client_detail->customer_id];
        }

        // check party
        $party_v2 = DB::connection($this->connect)->table('party')->where('id', $data->party_id)->first();

        // check client_info
        $client_info = DB::connection($this->connect)->table('client_info')->where('party_id', $data->party_id)->first();

        // check client_contact_detail
        $client_contact_details = DB::connection($this->connect)->table('client_contact_details')->where('party_id', $data->party_id)->first();


        // check migration_applications
        $migration_applications = DB::connection($this->connect)->table('migration_applications')->where('deal_id', $data->id)->first();

        if(!$party_v2 || !$client_info || !$client_contact_details || !$migration_applications) {
            return ['status' => 'missing' , 'deal' => null];
        }

        // dump($data);
        // dump($party_v2);
        // dump($client_info);
        // dump($client_contact_details);
        // dd($migration_applications);

        // get deal type
        $deal_type = null;
        switch ($data->deal_type) {
            case 'LEADS':
                # code...
                $deal_type = 1;
                break;
            case 'PROSPECT':
                # code...
                $deal_type = 2;
                break;
            case 'OPPORTUNITY':
                # code...
                $deal_type = 3;
                break;
            case 'CONVERTED':
                # code...
                $deal_type = 6;
                break;
        }
        


        try {

            $party = new Party;
            $person = new Person;
            $contact_detail = new ContactDetail;
            $deal = new Deal;
            $client_detail = new ClientDetail;

            DB::beginTransaction();
            $party->fill([
                'party_type_id'    => 1,
                'name'          => preg_replace('/\s+/', ' ', $client_info->firstname . ' ' . $client_info->middlename . ' ' . $client_info->lastname),
                // 'active'        => 1
            ]);

            $party->save();

            $person->fill([
                'firstname'     => $client_info->firstname,
                'middlename'    => isset($client_info->middlename) ? $client_info->middlename : null,
                'lastname'      => $client_info->lastname,
                'date_of_birth' => isset($client_info->dob) ? Carbon::parse($client_info->dob)->setTimezone('Australia/Melbourne')->format('Y-m-d') : null,
                'gender'        => isset($client_info->gender) ? $client_info->gender : null,
                'prefix'        => isset($client_info->title) ? $client_info->title : null,
                'person_type_id'   => 5
            ]);
            $person->party()->associate($party);
            $person->save();

            $phones = [];
            // phone 1
            if(isset($client_contact_details->mobile) && $client_contact_details->mobile != null){
                $phones[] = $client_contact_details->mobile;
            }
            // phone 2
            if(isset($client_contact_details->tel_no) && $client_contact_details->tel_no != null){
                $phones[] = $client_contact_details->tel_no;
            }

            $contact_detail->fill([
                'address_1' => isset($client_contact_details->res_address) ? $client_contact_details->res_address : null,
                'country_id' => isset($client_contact_details->country_id) ? $client_contact_details->country_id : null,
                'state' => isset($client_contact_details->res_state) ? $client_contact_details->res_state : null,
                'postcode' => isset($client_contact_details->res_postcode) ? $client_contact_details->res_postcode : null,
                'phones' => count($phones) > 0 ? $phones : null,
                // 'phone_1' => isset($client_contact_details->mobile) ? $client_contact_details->mobile : null,
                // 'phone_2' => isset($client_contact_details->tel_no) ? $client_contact_details->tel_no : null,
                'email' => isset($client_contact_details->email) ? $client_contact_details->email : null,
                'email_alt' => isset($client_contact_details->alt_email) ? $client_contact_details->alt_email : null,
                'emer_relationship' => isset($client_contact_details->emg_relationship) ? $client_contact_details->emg_relationship : null,
                'emer_name' => isset($client_contact_details->emg_name) ? $client_contact_details->emg_name : null,
                'emer_email' => isset($client_contact_details->emg_email) ? $client_contact_details->emg_email : null,
                'emer_address' => isset($client_contact_details->emg_address) ? $client_contact_details->emg_address : null,
                'emer_phone' => isset($client_contact_details->emg_telephone) ? $client_contact_details->emg_telephone : null,
            ]);
            $contact_detail->person()->associate($person);
            $contact_detail->save();
            
            $deal->fill([
                'deal_type_id' => $deal_type,
                'old_deal_id' => $data->id,
                'deal_source_id' => isset($data->source_id) ? $data->source_id : null
            ]);
            $deal->party()->associate($party);
            $deal->user()->associate(Auth::user());
            $deal->created_at = $data->created_at;
            $deal->active_date = Carbon::parse($data->created_at)->format('Y-m-d');
            $deal->save();
            
            $c_id = $this->generate_customer_id();
            // dump($c_id);
            $client_detail->fill([
                'customer_id'               => $c_id,
                'nationality_id'            => isset($migration_applications->nationality_id) ? $migration_applications->nationality_id : null,
                'current_visa_status'       => isset($migration_applications->current_visa_status_id) ? $migration_applications->current_visa_status_id : null,
                'expiration_date'           => isset($migration_applications->visa_expiration) && !in_array($migration_applications->visa_expiration, ['', null]) ? Carbon::parse($migration_applications->visa_expiration)->setTimezone('Australia/Melbourne')->format('Y-m-d') : null,
                'passport_no'               => $migration_applications->passport_no,
                'fifth_call'                => $migration_applications->fth_call == 1 ? 1 : 0,
                'college_currently_enroled' => $migration_applications->college_enroled,
                // 'referrer_customer_id'      => isset($migration_applications->'referrer']['customer_id']) ? $migration_applications->'referrer']['customer_id'] : null,
                'client_member'             => $migration_applications->client_member == 1 ? 1 : 0,
                'agent_id'                  => isset($migration_applications->agent_id) ? $migration_applications->agent_id : null,
                // 'assigned_to'               => isset($migration_applications->'assigned']['id']) ? $migration_applications->'assigned']['id'] : null,
            ]);
            $client_detail->deal()->associate($deal);
            $client_detail->save();

            // update client_detail_id in contact_details table
            $contact_detail->client_detail()->associate($client_detail);
            $contact_detail->update();

            DB::commit();

            // return ['status' => 'success', 'deal' => $deal->id, 'customer_id' => $client_detail->customer_id];
            return ['status' => 'success', 'deal' => $deal, 'customer_id' => $client_detail->customer_id];

        } catch (\Throwable $th) {
            DB::rollback();
            // return ['status' => 'error', 'msg' => $th];
            return ['status' => 'error', 'msg' => $th];
        }


    }

    public function create_notes($data)
    {
        if(isset($data['status']) && $data['status'] != 'error') {
            // dd($data['deal']);
            $deal = $data['deal'];

            // dump($deal->party->name);

            // check party
            $convos_v2 = DB::connection($this->connect)->table('deals_convos')->where('deal_id', $deal->old_deal_id)->get();
            

            foreach ($convos_v2 as $k => $v) {

                // if has users
                $user_note = User::where('old_user_id', $v->user_id)->first();
                $u = $user_note ? $user_note : User::find(1);
                
                // check deal notes table if note exist
                $note = DealNote::where('old_note_id', $v->id)->first();

                if(!$note) {
                    $note = new DealNote;
                    $note->note_type = $v->note_type;
                    $note->remarks = $v->remarks;
                    $note->old_note_id = $v->id;
                    $note->note_date = $v->created_at;
                    $note->deal()->associate($deal);
                    $note->user()->associate($u);
                    $note->save();
                    print (' note saved : # '. $note->id .' ');
                }else{
                    if($note->user_id == null) {
                        $note->user()->associate($u);
                        $note->update();
                    }
                    print ('note existed : # '. $note->id) . ' ';
                }

            }

            // dd($convos_v2);
            
            print (' | ');

            return ['status' => 'success'];

        }
        // dd('end notes');
    }

    public function create_attachments($data, $dealAtt = null)
    {
        if(isset($data['status']) && $data['status'] != 'error') {
            $deal = $data['deal'];
            if($dealAtt == null){
                $attachments = DB::connection($this->connect)->table('deals_attachments')->where('deal_id', $deal->old_deal_id)->whereNull('deleted_at')->get();
            }else{
                // dd($dealAtt->old_attachment_id);
                $attachments = DB::connection($this->connect)->table('deals_attachments')->where('id', $dealAtt->old_attachment_id)->whereNull('deleted_at')->get();
            }

            if($attachments->count() > 0){
                // dd($attachments);
                // dd($deal);
                foreach ($attachments as $k => $v) {


                    // test get file from vorx2 hosting
                    // dd($v);
                    // $path = '/public/attachments/deals/'.$v->deal_id.'/'.$v->attachment_code.'.'.$v->ext;
                    // $file = $v->attachment_code.'.'.$v->ext;
                    // $storage = Storage::disk('ftp')->url($path);


                    // dump($storage);
                    
                    // $new_path = '/app/public/client/'.$att->deal_id.'/attachments/old';
                    // if(is_dir(storage_path().$new_path) == false) {
                    //     mkdir(storage_path().$new_path, 0777, true);
                    // }
                    // if(file_exists($path)) {
                    //     copy($path, storage_path().$new_path.'/'.$file);
                    //     $att->path = $new_path.'/'.$file;
                    //     $att->hash_name = $v->attachment_code;
                    //     $att->update();
                    //    dump('path updated : '.$att->path);
                    // }else{
                    //     $file = $v->filename;
                    //     $path = 'D:/Projects/Kaur/Files/deals/'.$v->deal_id.'/'.$file;
                    //     if(file_exists($path)) {
                    //         $withoutExt = preg_replace('/\\.[^.\\s]{3,4}$/', '', $v->filename);
                    //         copy($path, storage_path().$new_path.'/'.$file);
                    //         $att->path = $new_path.'/'.$file;
                    //         $att->hash_name = $withoutExt;
                    //         $att->update();
                    //        dump('path updated : '.$att->path);
                    //     }else{
                    //        dump('no path');
                    //         dd($v);
                    //     }
                    // }
                    // dd('end');


                    // ---------------------------------------------------




                    // dump($v);
                    $custom_id = $v->deals_attachments_custom_id != null ? $v->deals_attachments_custom_id : null;
                    $folder = null;
                    // create folder
                    if($custom_id != null) {
                        $custom_att = DB::connection($this->connect)->table('deals_attachments_custom')->where('id', $custom_id)->first();
                        $folder = DealAttachmentFolder::where('old_custom_attachment_id', $custom_id)->first();
                        if(!$folder) {
                            $folder = new DealAttachmentFolder;
                            $folder->folder_name = $custom_att->name;
                            $folder->old_custom_attachment_id = $custom_id;
                            $folder->deal()->associate($deal);
                            $folder->save();
                        }
                    }

                    if(!in_array($v->attachment_type_id, [1,15])){
                        // dd($v->toArray());
                        $custom_att = DB::connection($this->connect)->table('mft_attachment_types')->where('id', $v->attachment_type_id)->first();
                        $folder = DealAttachmentFolder::where('folder_name', $custom_att->description)->where('deal_id', $deal->id)->first();
                        if(!$folder) {
                            $folder = new DealAttachmentFolder;
                            $folder->folder_name = $custom_att->description;
                            $folder->deal()->associate($deal);
                            $folder->save();
                        }
                    }

                    // create attachment
                    $att = DealAttachment::where('old_attachment_id', $v->id)->first();
                    if(!$att) {
                        $att = new DealAttachment([
                            'old_attachment_id' => $v->id,
                            'name' => $v->filename,
                            'hash_name' => $v->attachment_code,
                            'size' => $v->filesize,
                            'ext' => $v->ext,
                            'mime_type' => $v->mime_type,
                        ]);

                        if($folder) {
                            $att->deal_attachment_folder()->associate($folder);
                        }
                        // get user_attachment
                        $user = User::where('old_user_id', $v->user_id)->first();
                        if($user) {
                            $att->user()->associate($user);
                        }

                        $att->deal()->associate($deal);

                        $att->save();
                        print ('created attachment: #'. $att->id . ' ');
                    }else{
                        if($folder) {
                            $att->deal_attachment_folder()->associate($folder);
                            $att->update();
                        }
                        print ('attachment existed: #'. $att->id . ' ');
                    }

                    if($att->path == null) {
                        // $path = dirname(__FILE__);
                        // dump($v->id);
                        // dd($v->filepath);
                        // $path = 'D:/Projects/Kaur/Files/deals/'.$v->deal_id.'/'.$v->attachment_code.'.'.$v->ext;
                        // $file = $v->attachment_code.'.'.$v->ext;

                        $path = '/public/attachments/deals/'.$v->deal_id.'/'.$v->attachment_code.'.'.$v->ext;
                        $file = $v->attachment_code.'.'.$v->ext;
                        // $storage = Storage::disk('ftp')->exists($path);

                        print_r('new attachment -> '.$v->attachment_code);
                        
                        $new_path = '/public/client/'.$att->deal_id.'/attachments/old';
                        if(is_dir(storage_path().$new_path) == false) {
                            mkdir(storage_path().$new_path, 0777, true);
                        }
                        if(Storage::disk('ftp')->exists($path)) {
                            $ftpFile = storage::disk('ftp')->get($path);
                            Storage::put($new_path.'/'.$file, $ftpFile);
                            // copy(Storage::disk('ftp')->get($path), storage_path().$new_path.'/'.$file);
                            $att->path = '/app'.$new_path.'/'.$file;
                            $att->hash_name = $v->attachment_code;
                            $att->created_at = $v->created_at;
                            $att->updated_at = $v->updated_at;
                            $att->deleted_at = $v->deleted_at;
                            $att->update();
                            // dump('path updated : '.$att->path);
                            print ('path updated : '.$att->path . ' ');
                        }else{
                            $file = $v->filename;
                            // $path = 'D:/Projects/Kaur/Files/deals/'.$v->deal_id.'/'.$file;
                            $path = '/public/attachments/deals/'.$v->deal_id.'/'.$v->filename;
                            if(Storage::disk('ftp')->exists($path)) {
                                $ftpFile = storage::disk('ftp')->get($path);
                                Storage::put($new_path.'/'.$file, $ftpFile);
                                $withoutExt = preg_replace('/\\.[^.\\s]{3,4}$/', '', $v->filename);
                                // copy($path, storage_path().$new_path.'/'.$file);
                                $att->path = '/app'.$new_path.'/'.$file;
                                $att->hash_name = $withoutExt;
                                $att->created_at = $v->created_at;
                                $att->updated_at = $v->updated_at;
                                $att->deleted_at = $v->deleted_at;
                                $att->update();
                                print ('path in filename updated : '.$att->path . ' ');
                            }else{
                                $att->no_attachment = 1;
                                $att->update();
                                print ('no path ');
                                // dd($v);
                            }
                        }
                    }else{
                        print ('path existed : '.$att->path. ' ');
                    }

                    // dd('end');
                    print (' | ');
                }
            }

        }
    }
    
    public function create_invoice_payments($data)
    {
        $deal = $data;

        // get invoices
        $invoice = DB::connection($this->connect)->table('invoices')->where('deal_id', $deal->old_deal_id)->whereNull('deleted_at')->get();

        if($invoice->count() > 0 && $deal->deal_type_id < 3) {
            $deal->deal_type_id = 3;
            $deal->update();
        }

        foreach ($invoice as $k => $v) {
            $inv = Invoice::where('old_invoice_id', $v->id)->first();
            // dump($v);
            if(!$inv) {
                $inv = new Invoice;
                $inv->fill([
                    'old_invoice_id' => $v->id,
                    'invoice_date' => $v->invoiced_date,
                    'invoice_due_date' => $v->invoice_due_date,
                    'remarks' => $v->remarks,
                    'currency' => $v->currency,
                    'sub_total' => $v->sub_total,
                    'is_gst' => $v->is_gst,
                    'total_due' => $v->total_due,
                    'total_paid' => $v->total_paid,
                    'invoice_status' => $v->invoice_status,
                ]);
                $inv->deal()->associate($deal);
                $inv->created_at = $v->created_at;
                $inv->save();

                print('invoice created: #'.$inv->old_invoice_id. ' ');
            }else {
                $inv->created_at = $v->created_at;
                $inv->update();
                print('invoice existed: #'.$inv->old_invoice_id. ' ');
            }

            // get invoice details
            $invoice_details = DB::connection($this->connect)->table('invoice_details')->where('invoice_id', $inv->old_invoice_id)->whereNull('deleted_at')->get();
            // dd($invoice_details);
            foreach ($invoice_details as $kk => $vv) {
                $inv_det = InvoiceDetail::where('old_invoice_detail_id', $vv->id)->first();

                if(!$inv_det) {
                    $inv_det = new InvoiceDetail;
                    $inv_det->fill([
                        'old_invoice_detail_id' => $vv->id,
                        'line_item_title' => $vv->line_item_title,
                        'description' => $vv->description,
                        'quantity' => $vv->quantity,
                        'amount_paid' => $vv->amount_paid,
                        'amount_due' => $vv->amount_due,
                    ]);
                    $inv_det->invoice()->associate($inv);
                    $inv_det->created_at = $vv->created_at;
                    $inv_det->save();
                    print(' - invoice detail created: #'.$inv_det->old_invoice_detail_id. ' ');
                }else{
                    $inv_det->created_at = $vv->created_at;
                    $inv_det->update();
                    print(' - invoice detail existed: #'.$inv_det->old_invoice_detail_id. ' ');
                }
            }


            // get payments
            $payments = DB::connection($this->connect)->table('payments')->where('inv_no', $inv->old_invoice_id)->whereNull('deleted_at')->get();
            if($payments->count() > 0){    
                // dd($payments);
                foreach($payments as $vv) {
                    $pay = Payment::where('old_payment_id', $vv->id)->first();
                    if(!$pay) {
                        $pay = new Payment;
                        $pay->fill([
                            'old_payment_id' => $vv->id,
                            'payment_date' => $vv->payment_date,
                            'trxn_code' => $vv->trxn_code,
                            'remarks' => $vv->remarks,
                            'payment_type' => $vv->payment_type,
                            'source' => $vv->source,
                            'amount' => $vv->amount,
                            'status' => $vv->status,
                        ]);
                        $pay->created_at = $vv->created_at;
                        $pay->invoice()->associate($inv);
                        $user = User::where('old_user_id', $vv->user_id)->first();
                        $user = $user ? $user : User::find(1);
                        $pay->user()->associate($user);
                        $pay->save();
                        print('payment created: #'.$pay->old_payment_id. ' ');
                    }else{
                        $pay->created_at = $vv->created_at;
                        $pay->update();
                        print('payment existed: #'.$pay->old_payment_id. ' ');
                    }
                }

                // get payment detail
                $payment_details = DB::connection($this->connect)->table('payments_details')->where('payment_id', $pay->old_payment_id)->whereNull('deleted_at')->get();
                foreach($payment_details as $vvv) {
                    $pay_det = PaymentDetail::where('old_payment_detail_id', $vvv->id)->first();
                    if(!$pay_det) {
                        $pay_det = new PaymentDetail;
                        $pay_det->fill([
                            'old_payment_detail_id' => $vvv->id,
                            'payment_method_id' => $vvv->payment_method_id,
                            'amount' => $vvv->amount,
                        ]);
                        $pay_det->created_at = $vvv->created_at;
                        $pay_det->payment()->associate($pay);
                        $pay_det->save();
                        print (' - payment detail created: #'.$pay_det->old_payment_detail_id . ' ');
                    }else{
                        $pay_det->created_at = $vvv->created_at;
                        $pay_det->update();
                        print (' - payment detail existed: #'.$pay_det->old_payment_detail_id . ' ');
                    }
                }

            }

        }

        print (' | ');
        // dd($invoice);
    }

    public function getPaymentMethod()
    {
        $payments = Payment::with('payment_details.payment_method')->get();
        print ('Start --> ');
        foreach ($payments as $value) {
            if(isset($value->payment_details[0])){
                $count = $value->payment_details->count();
                $value->payment_method_id = $value->payment_details[$count-1]->payment_method_id;
                $value->update();
                print ($value->id .' is updated --> ');
            }
        }
        print ('<-> End <->');
    }

    public function generate_customer_id($customer_id = null)
    {
        $to = Organisation::first();
        // $client = null;
        // if($customer_id == null){
        //     $client = ClientDetail::where('customer_id', '!=', null)->latest()->first();
        //     $customer_id = $client ? $client->customer_id : null;
        // }
        $client = ClientDetail::where('customer_id', '!=', null)->latest()->first();
        $customer_id = $client ? $client->customer_id : null;
        $next_no = $customer_id != null ? abs(str_replace($to->client_id_prefix,"",$customer_id)) : 0;
        $next = 0;
        $next_id = '';
        while ($next != 1) {
            
            $prefix = in_array($to->client_id_prefix, [null, '']) ? 'VRX' : $to->client_id_prefix;
            $next_id = $prefix . str_pad($next_no , 5, 0, STR_PAD_LEFT);
            $check = ClientDetail::where('customer_id', $next_id)->first();
            
            if($check){
                $next_no++;
            }else {
                $next = 1;
            }
        }
        // dump('-> '.$next_id);
        return $next_id;
        // dump($next_id);
        
        // dd($check);
        // if(isset($check->id)) {
            // dump('check -> '. $check->customer_id);
        // } else{ 
            // dump('check -> none -> ' . $next_id);
        // }
        // dump('****************************************************');
        // if(isset($check->id)){
        //     $this->generate_customer_id($next_id);
        // }else {
        //     dump($next_id . '<-');
        //     return $next_id;
        // }
        
    }
}
