<?php

namespace App\Http\Controllers\Documents;

use App\Http\Controllers\Controller;
use App\Models\ExternalLink;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class ExternalLinkController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        \JavaScript::put([
            'userRole' => Auth::user()->roles[0]->name, 
        ]);

        return view('documents.external.index');
    }

    public function list()
    {
        $list = ExternalLink::orderBy('id', 'desc')->get();

        return $list;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        // dd($request);

        $attributes = [
            'url' => 'URL',
            'description' => 'Description',
        ];

        
        $validate = Validator::make($request->all(), [
            'url' => 'required|url',
            'description' => 'required',
        ], [], $attributes);
        
        if ($validate->fails()) {
            return response()->json(['status' => 'errors', 'errors' => $validate->messages()]);
        }

        try {

            DB::beginTransaction();

            if(isset($request->id)) {
                // update
                $external = ExternalLink::find($request->id);
                $external->fill($request->all());
                $external->update();
            }else {
                // create
                $external = new ExternalLink;
                $external->fill($request->all());
                $external->save();
            }

            DB::commit();


            return ['status' => 'success'];

        } catch (\Throwable $th) {
            DB::rollback();
            throw $th;
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        try {

            DB::beginTransaction();

            $data = ExternalLink::find($id);

            if(!$data) {
                return ['status' => 'error'];
            }

            $data->delete();

            DB::commit();

            return ['status' => 'success'];

        } catch (\Throwable $th) {
            DB::rollback();
            throw $th;
        }
    }
}
