<?php

namespace App\Http\Controllers\Deals;

use App\Http\Controllers\Controller;
use App\Models\Invoice;
use App\Models\Payment;
use App\Models\PaymentDetail;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class DealPaymentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        

        $invoice = Invoice::find($request->invoice['id']);

        $pay = isset($request->payment['id']) ? $request->except('payment.trxn_code')['payment'] : $request->payment;

        if(!isset($pay['id']) && isset($pay['trxn_code']) && !in_array($pay['trxn_code'], ['',null])) {
            $check = Payment::where('trxn_code', $pay['trxn_code'])->first();
            if($check) {
                return ['status' => 'errors', 'msg' => 'Transaction code already existed'];
            }
        }

        // dump(Carbon::parse($request->payment['payment_date'])->setTimezone('Australia/Melbourne')->format('Y-m-d H:i:s'));
        // dd($pay);

        try {

            DB::beginTransaction();

            if(isset($pay['id'])) {
                // update
                $payment = Payment::find($pay['id']);
                $payment->fill($pay);
                $payment->payment_date = isset($pay['payment_date']) && !in_array($pay['payment_date'], ['', null, '0000-00-00']) ? Carbon::parse($pay['payment_date'])->setTimezone('Australia/Melbourne')->format('Y-m-d H:i:s') : null;
                $payment->update();
            }else {
                // create
                $payment = new Payment($pay);
                $payment->payment_date = isset($pay['payment_date']) && !in_array($pay['payment_date'], ['', null, '0000-00-00']) ? Carbon::parse($pay['payment_date'])->setTimezone('Australia/Melbourne')->format('Y-m-d H:i:s') : null;
                $payment->trxn_code = isset($pay['trxn_code']) && !in_array($pay['trxn_code'], ['',null]) ? $pay['trxn_code'] : $this->generateRandomString();
                $payment->invoice()->associate($invoice);
                $payment->status = 'Open';
                $payment->user()->associate(Auth::user());
                $payment->save();
            }
            if(isset($payment->payment_details[0])){
                // update
                $payment->payment_details[0]->payment_method_id = $pay['payment_method_id'];
                $payment->payment_details[0]->amount = $pay['amount'];
                $payment->payment_details[0]->update();
            }else{
                // create
                $pay_det = new PaymentDetail([
                    'payment_method_id' => $pay['payment_method_id'],
                    'amount' => $pay['amount'],
                ]);
                $pay_det->payment()->associate($payment);
                $pay_det->save();
            }

            // invoice update;
            $total_payment = $invoice->payments->whereNotIn('status', ['Cancelled', 'Pending', 'Rejected'])->sum('amount');

            $inv_status = $invoice->invoice_status;
            if($invoice->total_due > $total_payment) {
                $inv_status = 'Partial';
            }elseif($invoice->total_due == $total_payment){
                $inv_status = 'Paid';
            }elseif($total_payment <= 0) {
                $inv_status = 'Unpaid';
            }

            $invoice->total_paid = $total_payment;
            $invoice->invoice_status = $inv_status;
            $invoice->update();

            DB::commit();


            return ['status' => 'success'];

        } catch (\Throwable $th) {
            DB::rollback();
            throw $th;
        }


    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $payment = Payment::find($id);
        $invoice = $payment->invoice;
        
        foreach ($payment->payment_details as $value) {
            $value->delete();
        }

        $payment->delete();

        // invoice update;
        $total_payment = $invoice->payments->whereNotIn('status', ['Cancelled', 'Pending', 'Rejected'])->sum('amount');

        $inv_status = $invoice->invoice_status;
        if($invoice->total_due > $total_payment) {
            $inv_status = 'Partial';
        }elseif($invoice->total_due == $total_payment){
            $inv_status = 'Paid';
        }
        
        if($total_payment <= 0) {
            $inv_status = 'Unpaid';
        }

        $invoice->total_paid = $total_payment;
        $invoice->invoice_status = $inv_status;
        $invoice->update();

        return ['status' => 'success'];
    }

    public function generateRandomString($length = 16) {
        $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }

        $check = Payment::where('trxn_code', $randomString)->first();

        if($check) {
            $this->generateRandomString();
        }else{
            return $randomString;
        }

    }

}
