<?php

namespace App\Http\Controllers\Deals;

use App\Http\Controllers\Controller;
use App\Models\Deal;
use App\Models\DealNote;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DealNotesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $deal = Deal::find($request->deal_id);
        // dd($deal);
        try {
            DB::beginTransaction();

            if(isset($request->note['id'])) {
                $note = DealNote::where('id', $request->note['id'])->first();
                $note->remarks = $request->note['remarks'];
                $note->note_type = $request->type;
                $note->update();
                $status ='updated';
            }else {
                $note = new DealNote;
                $note->remarks = $request->note['remarks'];
                $note->note_type = $request->type;
                $note->note_date = Carbon::now()->setTimezone('Australia/Melbourne')->format('Y-m-d H:i:s');
                $note->deal()->associate($deal);
                $note->user()->associate(\Auth::user());
                $note->save();
                $status ='saved';
            }

            DB::commit();
            
            return ['status' => $status];

        } catch (\Throwable $th) {
            DB::rollback();
            throw $th;
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, $type = '*')
    {
        //
        // dd($type);
        $notes = DealNote::with(['user.party'])->where('deal_id', $id)->where('note_type', $type == '*' ? '!=' : '=', $type)->orderBy('note_date', 'desc')->get();
        return ['notes' => $notes, 'type' => $type];

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        try {
            DB::beginTransaction();
            $note = DealNote::where('id', $id)->first();
            $note->delete();
            DB::commit();
            return ['status' => 'success'];
        }catch (\Throwable $th) {
            DB::rollback();
            throw $th;
        }
    }
}
