<?php

namespace App\Http\Controllers\Deals;

use App\Http\Controllers\Controller;
use App\Models\Deal;
use App\Models\DealType;
use App\Models\Invoice;
use App\Models\InvoiceDetail;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class DealInvoiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        // dd($request->all());
        $inv = $request->invoice;

        if(!isset($inv['invoice_date']) && in_array($inv['invoice_date'], ['', null, '0000-00-00']) || !isset($inv['invoice_date']) && in_array($inv['invoice_date'], ['', null, '0000-00-00']) || !isset($request->details[0])) {
            return ['status' => 'errors', 'msg' => 'Please fill all required fields and add invoice details.'];
        } 


        try {

            DB::beginTransaction();

            if(isset($request->invoice['id'])) {
                // update invoice
                $invoice = Invoice::find($inv['id']);
                $invoice->fill([
                    'invoice_date' => isset($inv['invoice_date']) && !in_array($inv['invoice_date'], ['', null, '0000-00-00']) ? Carbon::parse($inv['invoice_date'])->setTimezone('Australia/Melbourne')->format('Y-m-d') : null,
                    'invoice_due_date' => isset($inv['invoice_due_date']) && !in_array($inv['invoice_due_date'], ['', null, '0000-00-00']) ? Carbon::parse($inv['invoice_due_date'])->setTimezone('Australia/Melbourne')->format('Y-m-d') : null,
                    'remarks' => isset($inv['invoice_date']) ? $inv['remarks'] : null,
                    'is_gst' => isset($inv['is_gst']) && in_array($inv['is_gst'], [1, true]) ? 1 : 0,
                    'sub_total' => round($request->subtotal, 2),
                    'total_due' => round($request->totalDue, 2),
                ]);
                $invoice->update();

            }else{
                // create invoice
                $deal = Deal::find($request->deal_id);

                $invoice = new Invoice([
                    'invoice_date' => isset($inv['invoice_date']) && !in_array($inv['invoice_date'], ['', null, '0000-00-00']) ? Carbon::parse($inv['invoice_date'])->setTimezone('Australia/Melbourne')->format('Y-m-d') : null,
                    'invoice_due_date' => isset($inv['invoice_due_date']) && !in_array($inv['invoice_due_date'], ['', null, '0000-00-00']) ? Carbon::parse($inv['invoice_due_date'])->setTimezone('Australia/Melbourne')->format('Y-m-d') : null,
                    'remarks' => isset($inv['invoice_date']) ? $inv['remarks'] : null,
                    'is_gst' => isset($inv['is_gst']) && in_array($inv['is_gst'], [1, true]) ? 1 : 0,
                    'sub_total' => round($request->subtotal, 2),
                    'total_due' => round($request->totalDue, 2),
                    'total_paid' => 0.00,
                    'invoice_status' => 'Unpaid',
                ]);
                $invoice->deal()->associate($deal);
                $invoice->user()->associate(Auth::user());
                $invoice->save();
                // dd($invoice);

                // update deal type if prospect
                if($deal->deal_type_id == 2) {
                    $deal->deal_type()->associate(DealType::find(3));
                    $deal->update();
                }
            }

            $invoice_details = $request->details;

            foreach ($invoice_details as $k => $v) {
                if(isset($v['id'])) {
                    // update
                    $inv_det = InvoiceDetail::find($v['id']);
                    $inv_det->fill([
                        'line_item_title' => $v['line_item_title'],
                        'description' => $v['description'],
                        'quantity' => $v['quantity'],
                        'amount_paid' => $v['amount_paid'],
                        'amount_due' => $v['amount_due'],
                    ]);
                    $inv_det->update();

                }else {
                    // create
                    $inv_det = new InvoiceDetail([
                        'line_item_title' => $v['line_item_title'],
                        'description' => $v['description'],
                        'quantity' => $v['quantity'],
                        'amount_paid' => $v['amount_paid'],
                        'amount_due' => $v['amount_due'],
                    ]);
                    $inv_det->invoice()->associate($invoice);
                    $inv_det->save();
                    // dd($inv_det);
                }
            }

            
            // dd('end');

            DB::commit();


            return ['status' => 'success'];

        } catch (\Throwable $th) {
            DB::rollback();
            throw $th;
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $invoices = Invoice::with(['payments.user.party', 'payments.payment_method', 'invoice_details'])->where('deal_id', $id)->orderBy('id', 'desc')->get();

        return $invoices;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $invoice = Invoice::find($id);
        
        $payments = $invoice->payments;

        foreach ($payments as $value) {
            foreach ($value->payment_details as $v) {
                $v->delete();
            }
            $value->delete();
        }

        foreach ($invoice->invoice_details as $value) {
            $value->delete();
        }

        $invoice->delete();

        return ['status' => 'success'];

    }
}
