<?php

namespace App\Http\Controllers\Deals;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Setup\Automation\ImageFileController;
use App\Models\Deal;
use App\Models\DealAttachment;
use App\Models\DealAttachmentFolder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use File;
use Storage;

class DealAttachmentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, $deal_id)
    {
        //
        $path = '';
        $file = null;

        try {
            DB::beginTransaction();

            $file = $request->file('files');

            // $path = $file->store('public/client/'.$deal_id.'/attachments/new/');

            $path = ImageFileController::upload($file, $deal_id, 'deal');

            $hashFileName = preg_replace('/\\.[^.\\s]{3,4}$/', '', $file->hashName());
            
            $deal = Deal::where('id', $deal_id)->first();

            $att = new DealAttachment([
                'name'      => $file->getClientOriginalName(),
                'hash_name' => $hashFileName,
                'path'      => '/app/public/client/'.$deal_id.'/attachments/new/'.$hashFileName.'.'.$file->guessClientExtension(),
                'size'      => $file->getClientSize(),
                'mime_type' => $file->getMimeType(),
                'ext'       => $file->guessClientExtension(),
                '_input'       => 'attachment',
            ]);
            $f = DealAttachmentFolder::where('id', $request->folder_id)->first();
            if($f) {
                $att->deal_attachment_folder()->associate($f);
            }
            $att->user()->associate(\Auth::user());
            $att->deal()->associate($deal);
            $att->aws_path = $path;
            $att->save();

            DB::commit();

            $file_path = '/storage/public/client/'.$att->deal_id.'/new/attachments/' . $att->hash_name . '.' . $att->ext;

            $file = [
                'id' => $att->id,
                'lastModified' => $att->updated_at->timestamp,
                'lastModifiedDate' => $att->updated_at,
                'name' => $att->name,
                'size' => $att->size,
                'file_path' => $file_path,
                'file_ext' => $att->ext,
                'file_type' => explode('/', $att->mime_type)[0],
            ];

            // return response(['status' => 'success', 'attID' => $attID, 'preview' => $preview], 200)->header('Content-Type', 'text/json');
            return response(['status' => 'success', 'file' => $file], 200)->header('Content-Type', 'text/json');
            // return response(['status' => 'success', 'attID' => 0], 200)->header('Content-Type', 'text/json');
        } catch (\Exception $e) {
            DB::rollBack();

            // remove file
            Storage::delete($path);
            dd($e->getMessage());
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, $folder_id = 'default')
    {
        //
        // dd($id);
        $folder_id = $folder_id == 'default' ? null : $folder_id;
        $dealAttachments = DealAttachment::where('deal_id' , $id)->where('deal_attachment_folder_id', $folder_id)->get();
        
        $attachments = [];

        foreach ($dealAttachments as $key => $value) {
            $file_path = '';
            $path_old = null;
            $path_new = null;

            $path_new = '/storage/client/' . $value->deal_id . '/attachments/new/' . $value->hash_name . '.' . $value->ext;
            $path_old = '/storage/client/' . $value->deal_id . '/attachments/old/' . $value->hash_name . '.' . $value->ext;
            
            $file_path = $value->old_attachment_id != null ? $path_old : $path_new;
            array_push($attachments, [
                'id' => $value->id,
                'lastModified' => isset($value->updated_at->timestamp) ? $value->updated_at->timestamp : null,
                'lastModifiedDate' => $value->updated_at,
                'deal_attachment_folder_id' => $value->deal_attachment_folder_id,
                'name' => $value->name,
                'size' => $value->size,
                'file_exist' => $value->path != null ? true : false,
                'file_path' => str_replace(' ', '%20', $file_path),
                'file_ext' => $value->ext,
                'file_type' => explode('/', $value->mime_type)[0],
            ]);
        }

        return $attachments;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $clientAttachment = DealAttachment::where('id', $id)->first();
        
        if($clientAttachment){
            if ($clientAttachment->path_id == $clientAttachment->student_id) {
                $file_path = '/storage/student/new/attachments/' . $clientAttachment->student_id . '/' . $clientAttachment->hash_name . '.' . $clientAttachment->ext;
            } else {
                $file_path = '/storage/student/old/attachments/' . $clientAttachment->path_id . '/' . $clientAttachment->hash_name . '.' . $clientAttachment->ext;
            }
    
            $file_path = storage_path() . '/app/public/client/' . $clientAttachment->deal_id . '/attachments/new/' . $clientAttachment->hash_name . '.' . $clientAttachment->ext;
            
            if(file_exists($file_path)){
                Storage::delete($file_path);
            }
            $clientAttachment->delete();
            return ['status' => 'success'];

        }else{
            return ['status' => 'error'];
        }
    }

    public function preview($id)
    {
        $file = DealAttachment::find($id);

        // get file from aws s3
        return ImageFileController::preview($file);

        // $file = DealAttachment::find($id);
        // $path_old = null;
        // $path_new = null;
        // $path = null;

        // $path = storage_path() . $file->path;
        
        // // $path = file_exists($path_old) ? $path_old : $path_new;
        
        // // raw file contents
        // $fileContent = File::get($path);

        // return response($fileContent)->header('Content-Type', $file->mime_type);
    
    }

    public function rename(Request $request, $id){
        try {
            DB::beginTransaction();

            $clientAttachment = DealAttachment::where('id', $id)->first();
            $clientAttachment->name = $request->rename;
            $clientAttachment->update();

            DB::commit();
            return json_encode(['status' => 'updated']);
        } catch (\Exception $e) {
            DB::rollBack();

            // remove file
            return $e->getMessage();
        }
    }


    // Attachment Folder Functions

    public function show_attachment_folders($id)
    {
        $folders = DealAttachmentFolder::with(['attachments'])->where('deal_id', $id)->get();
        
        foreach ($folders as $key => $v) {
            # code...
            // dd($atts);
            $attachments = [];
            foreach ($v->attachments as $key => $value) {
                $file_path = '';
                $path_old = null;
                $path_new = null;
    
                $path_new = '/storage/client/' . $value->deal_id . '/attachments/new/' . $value->hash_name . '.' . $value->ext;
                
                $file_path = file_exists($path_old) ? $path_old : $path_new;
    
                array_push($attachments, [
                    'id' => $value->id,
                    'lastModified' => isset($value->updated_at->timestamp) ? $value->updated_at->timestamp : null,
                    'lastModifiedDate' => $value->updated_at,
                    'deal_attachment_folder_id' => $value->deal_attachment_folder_id,
                    'name' => $value->name,
                    'size' => $value->size,
                    'file_path' => $file_path,
                    'file_ext' => $value->ext,
                    'file_type' => explode('/', $value->mime_type)[0],
                ]);
            }

            $v->prevAttachments = $attachments;

        }

        return $folders;
    }

    public function create_folder(Request $request)
    {
        try {
            DB::beginTransaction();
            $deal = Deal::where('id', $request->deal_id)->first();
            
            $folder = new DealAttachmentFolder;
            $folder->folder_name = $request->createFolder;
            $folder->deal()->associate($deal);
            $folder->save();
            DB::commit();

            return ['status' => 'success'];

        }catch (\Throwable $th) {
            DB::rollback();
            throw $th;
        }
    }

    public function rename_folder(Request $request)
    {
        try {
            DB::beginTransaction();
            $folder = DealAttachmentFolder::where('id', $request->folder_id)->first();
            $folder->folder_name = $request->renameFolder;
            $folder->update();
            DB::commit();

            return ['status' => 'success'];

        }catch (\Throwable $th) {
            DB::rollback();
            throw $th;
        }

    }

    public function delete_folder($id)
    {
        $folder = DealAttachmentFolder::with('attachments')->where('id', $id)->first();

        if($folder) {
            if ($folder->attachments->count() > 0) {
                return ['status' => 'error', 'msg' => 'Folder has attachments, please remove attachments first.'];
            }else {
                
                $folder->delete();
                return ['status' => 'success'];
            }
        }else{
            return ['status' => 'error', 'msg' => 'No folder has been detected for deletion'];
        }


    }

    public function download($id)
    {

        $att = DealAttachment::find($id);

        return ImageFileController::preview($att, true);

        // $path = storage_path($att->path);

        // $filetype=filetype($path);
        // $filename=basename($path);
        // header ("Content-Type: ".$filetype);
        // header ("Content-Length: ".filesize($path));
        // header ("Content-Disposition: attachment; filename=".$att->name);

        // readfile($path);

    }
}
