<?php

namespace App\Http\Controllers\Deals;

use App\Http\Controllers\Controller;
use App\Models\ClientService;
use App\Models\Deal;
use App\Models\DealAttachmentFolder;
use App\Models\User;
use Illuminate\Http\Request;

class ClientServiceController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        // dd($request->all());

        $cs = new ClientService;

        $name = $request->service_type;
        $service_details = [];
        if(isset($request->visa_type['id'])) {
            $name .= ' - '. $request->visa_type['visa'];
            $service_details['visa_type'] = $request->visa_type;
        }
        
        $cs->service_name = $name;
        $cs->service_code = $this->generateRandomString();
        $cs->service_details = $service_details;
        $cs->amount = $request->amount;

        $cs->deal()->associate(Deal::find($request->deal_id));
        if(isset($request->assigned_to->id)){
            $cs->assigned_to()->associate(User::find($request->assigned_to->id));
        }

        $cs->save();


        // create attachment folder
        $att_folder = DealAttachmentFolder::where('folder_name', $name)->first();
        if(!$att_folder) {
            $att_folder = new DealAttachmentFolder([
                'folder_name' => $name,
            ]);
            $att_folder->deal()->associate(Deal::find($request->deal_id));
            $att_folder->save();
        }

        return ['status' => 'success'];

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $services = ClientService::with(['deal', 'assigned_to'])->where('deal_id', $id)->orderBy('id', 'desc')->get();
        return $services;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function generateRandomString($length = 10) {
        $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }

        $check = ClientService::where('service_code', $randomString)->first();

        if($check) {
            $this->generateRandomString($length);
        }else{
            return $randomString;
        }

    }
}
