<?php

namespace App\Http\Controllers\Deals;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Send\EmailSendingController;
use App\Models\AgentDetail;
use App\Models\Deal;
use App\Models\DealSource;
use App\Models\DealStatus;
use App\Models\DealType;
use Illuminate\Http\Request;
use Carbon\Carbon;

// VORX RTO MODELS


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Illuminate\Support\Facades\File;
use PhpOffice\PhpSpreadsheet\RichText\RichText;

class ClientReportController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        //
    }

    public function generate_excel($data)
    {
        
        if(count($data) == 0){
            return ['status' => 'error'];
        }
        
        $clients = $data;

        $headers = array_keys($clients[0]);

        $path = storage_path('app/excel');
        File::makeDirectory($path, $mode = 0777, true, true);

        // dd($path);

        $spreadsheet = new Spreadsheet();
        $spreadsheet->getDefaultStyle()->getFont()->setSize(11);
        $sheet = $spreadsheet->getActiveSheet();

        

        $richTitle = new RichText();
        $title = 'Client Details ( '. $clients[0]['Full Name'] . ' )'; 
        $titleBolds = $richTitle->createTextRun($title);
        $titleBolds->getFont()->setBold(true)->setSize(26);
        // dump($richTitle);
        $sheet->setCellValue('A1', $richTitle);

        // headers
        $letter = 'A';
        foreach ($headers as $item){
            // $itm = $richText->createTextRun($item)->getFont()->setBold(true);
            $spreadsheet->getActiveSheet()->getColumnDimension($letter)->setAutoSize(true);
            $richText = new RichText();
            $bolds = $richText->createTextRun($item);
            $bolds->getFont()->setBold(true)->setSize(12);
            // dump($richText);
            $sheet->setCellValue($letter.'3', $richText);
            $letter++;
        }

        // Merge for Title
        $sheet->mergeCells('A1:'.$letter.'1');

        // body
        $number = 4;
        // for ($number = 1 ; count($clients) > $number ; $number++){
        foreach ($clients as $item){
            $letter = 'A';
            foreach ($item as $v){
                $var = $letter.''.$number;
                $sheet->setCellValue($var, $v);
                $letter++;
            }
            $number++;
        }
        // }
        
        
        $writer = new Xlsx($spreadsheet);
        
        $f = $path.'/Client Details.xlsx';

        $writer->save($f);

        // dd('exported');

        return [
            'status' => 'success',
            'file' => 'Client Details.xlsx',
            'rename' => $clients[0]['Client ID'].' - '. $clients[0]['Full Name']. '.xlsx'
        ];

    }

    public function download($type,$file,$rename)
    {

        $path = storage_path('app/'.$type);

        $f = $path.'/'.$file;

        // dd($f);

        $filetype=filetype($f);
        $filename=basename($f);
        header ("Content-Type: ".$filetype);
        header ("Content-Length: ".filesize($f));
        header ("Content-Disposition: attachment; filename=".$rename);

        readfile($f);
    }
    

    public function client_details(Request $request)
    {

        $client = Deal::with(['deal_type', 'convos','notes','deal_source','deal_status','party.person.contact_detail.country', 'client_detail.nationality', 'client_detail.visa_status', 'client_detail.assigned.party', 'client_detail.referrer.deal.party.person.contact_detail', 'invoices.payments.user.party', 'invoices.invoice_details'])->where('id', $request->client['id'])->first();

        $clients = [];
        
        if(!isset($client)){
            return ['status' => 'error'];
        }

            // foreach($deals as $item){
                $convo_list = [];
                $note_list = [];

                if(count($client->convos) > 0){
                    foreach($client->convos as $con){
                        $convo_list[] = $this->get_data($con->note_date, 'datetime').' - '.$con->remarks;
                    }
                }
                if(count($client->notes) > 0){
                    foreach($client->notes as $note){
                        $note_list[] = $this->get_data($note->note_date, 'datetime').' - '.$note->remarks;
                    }
                }

                $clients[] = [
                    'Client ID' => $client->client_detail->customer_id,
                    'Full Name' => $client->party->name,
                    'Deal Type' => $client->deal_type->type,
                    'Deal Source' => isset($client->deal_source->source_name) ? $client->deal_source->source_name : '',
                    'Date of Birth' => $this->get_data($client->party->person->date_of_birth, 'date'),
                    'Email Address' => $client->party->person->contact_detail->email,
                    'Alternative Email' => $client->party->person->contact_detail->email_alt ?? '',
                    'Phone # 1' => isset($client->party->person->contact_detail->phones[0]) ? $this->get_data($client->party->person->contact_detail->phones[0]) : null,
                    'Phone # 2' => isset($client->party->person->contact_detail->phones[1]) ? $this->get_data($client->party->person->contact_detail->phones[1]) : null,
                    'Phone # 3' => isset($client->party->person->contact_detail->phones[2]) ? $this->get_data($client->party->person->contact_detail->phones[2]) : null,
                    'Address' => $client->party->person->contact_detail->address_1,
                    'State' => $client->party->person->contact_detail->state,
                    'Postcode' => $client->party->person->contact_detail->postcode,
                    'Country' => isset($client->party->person->contact_detail->country->full_name) ? $client->party->person->contact_detail->country->full_name : null,
                    '5th Call' => $client->client_detail->fifth_call == 1 ? 'Yes' : 'No',
                    'Nationality' => isset($client->client_detail->nationality->nationality) ? $client->client_detail->nationality->nationality : null,
                    'Visa Status' => isset($client->client_detail->visa_status->visa) ? $client->client_detail->visa_status->visa : null,
                    'Expiration Date' => isset($client->client_detail->expiration_date) ? $this->get_data($client->client_detail->expiration_date, 'date') : null,
                    'Passport' => isset($client->client_detail->passport) ? $this->get_data($client->client_detail->passport) : null,
                    'College Currently Enroled' => isset($client->client_detail->college_currently_enroled) ? $this->get_data($client->client_detail->college_currently_enroled) : null,
                    'Client Member Card No.' => isset($client->client_detail->client_member_card_no) ? $this->get_data($client->client_detail->client_member_card_no) : null,
                    'Referrer' => isset($client->client_detail->referrer->deal->party->name) ? $this->get_data($client->client_detail->referrer->deal->party->name) : null,
                    'Assigned To' => isset($client->client_detail->assigned->party->name) ? $this->get_data($client->client_detail->assigned->party->name) : null,
                    // 'Last Convo' => isset($client->convos[0]) ? $client->convos[0]->remarks : '',
                    'Date Created' => $this->get_data(Carbon::parse($client->created_at)->format('Y-m-d'), 'date'),
                    'Conversation' => implode("\r\n \r\n", $convo_list),
                    'Note' => implode("\r\n \r\n", $note_list),
                    
                ];
                // dd($clients);
            // }
        $data = $this->generate_excel($clients);

        if($data['status'] == 'success'){
            return $data;
        }else{
            return ['status' => 'error'];
        }
        
    }

    public function get_data($data, $type = 'text')
    {
        $data = !in_array($data, ['', null]) ? $data : null;

        if($data != null){
            switch ($type) {
                case 'date':
                    $data = Carbon::createFromFormat('Y-m-d', $data)->format('d/m/Y');
                    break;
    
                case 'int':
                    $data = intval($data);
                    break;
                
                case 'datetime':
                    $data = Carbon::createFromFormat('Y-m-d H:i:s', $data)->format('d/m/Y h:i:s A');
                    break;
    
            }
        }
        return $data;
    }


    public function generate_pdf($id){

        $client = Deal::with(['deal_type', 'convos','notes','deal_source','deal_status','party.person.contact_detail.country', 'client_detail.nationality', 'client_detail.visa_status', 'client_detail.assigned.party', 'client_detail.referrer.deal.party.person.contact_detail', 'invoices.payments.user.party', 'invoices.invoice_details'])->where('id', $id)->first();
        
        if(!isset($client)){
            abort(403, 'File not found.');
        }

        $path = storage_path('app/pdf');
        if (!File::isDirectory($path)) {
            File::makeDirectory($path, $mode = 0777, true, true);
        }
        
        $filename = $client->client_detail->customer_id. ' - '. $client->party->name . '.pdf';

        \PDF::loadView('clients.client-details-pdf', compact('client'))->setPaper(array(0, 0, 794, 1122), 'portrait')->save($path.'/Client Details.pdf')->stream($filename);

        return \PDF::loadView('clients.client-details-pdf', compact('client'))->setPaper(array(0, 0, 794, 1122), 'portrait')->stream($filename);
    }
}
