<?php

namespace App\Http\Controllers\Deals;

use App\Http\Controllers\Controller;
use App\Http\Resources\ClientReminderCollection;
use App\Http\Resources\ClientResource;
use App\Models\ClientDetail;
use App\Models\ClientReminder;
use App\Models\Deal;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class ClientReminderController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //

        \JavaScript::put([
            'userRole' => Auth::user()->roles[0]->name,
            'users' => User::with('party')->where('id', '!=', 1)->get(), 
        ]);

        return view('clients.reminders.index');
    }

    public function fetch_reminders(Request $request)
    {
        $reminders = collect();

        // $reminders = ClientReminder::with(['deal.party'])->orderBy('reminder_date')->orderBy('reminder_time')->get();
        if ($request->sort) {
            $sort = $request->sort;
            $direction = $request->direction;

            // if (isset($request->search) && $request->search != null) {
            
            // }else {
                $reminders = ClientReminder::with(['deal.party'])->orderBy('id', 'desc');

            // }

        }
        // dump($request->all());
        // dd($reminders->paginate($request->limit));
        
        return ClientReminderCollection::collection($reminders->paginate($request->limit));
        // return $reminders->paginate($request->limit);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        // $request->request->add($request->reminder);
        // dump($request->all());
        // dd($request->reminder);


        $attributes = [
            'reminder.subject' => 'Subject',
            'reminder.content' => 'Reminder',
            'reminder.reminders_to' => 'Reminders To',
            'reminder.reminder_date' => 'Reminder Date',
            'reminder.reminder_time' => 'Reminder Time',
        ];
        
        $validate = Validator::make($request->all(), [
            'reminder.content' => 'required',
            'reminder.content' => 'required',
            'reminder.reminders_to' => 'required',
            'reminder.reminder_date' => 'required',
            'reminder.reminder_time' => 'required',
        ], [], $attributes);
    
        
        if ($validate->fails()) {
            return response()->json(['status' => 'errors', 'errors' => $validate->messages()]);
        }

        try {
            
            DB::beginTransaction();

            if($request->is_update == 0){
                $remind = new ClientReminder;
                $remind->fill($request->reminder);
                $remind->reminder_date = Carbon::parse($request->reminder['reminder_date'])->setTimezone('Australia/Melbourne')->format('Y-m-d');
                $remind->deal()->associate(Deal::find($request->deal_id));
                $remind->user()->associate(Auth::user());
                $remind->save();

            }else{
                $remind = ClientReminder::where('id', $request->reminder['id'])->first();
                $remind->fill($request->reminder);
                $remind->reminder_date = Carbon::parse($request->reminder['reminder_date'])->setTimezone('Australia/Melbourne')->format('Y-m-d');
                $remind->update();
            }
            
            DB::commit();


            return ['status' => 'success'];

        } catch (\Throwable $th) {
            DB::rollback();
            throw $th;
        }


    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $reminders = ClientReminder::where('deal_id', $id)->get();

        return $reminders;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $reminder = ClientReminder::find($id);
        
        if($reminder) {
            $reminder->delete();
            return ['status'=>'success'];
        }else{
            return ['status' => 'error'];
        }

    }

    public function reminder_list()
    {
        $reminders = ClientReminder::with(['deal.party'])->where('is_done', 0)->orderBy('reminder_date')->orderBy('reminder_time')->get();
        $reminders = $reminders ? $reminders : [];
        return $reminders;
    }

    public function is_done(Request $request)
    {
        $reminder = ClientReminder::find($request->id);
        $reminder->is_done = 1;
        $reminder->update();
        return ['status' => 'success'];
    }
}
