<?php

namespace App\Http\Controllers\Agents;

use App\Http\Controllers\Controller;
use App\Models\Agent;
use App\Models\AgentAttachment;
use App\Models\AgentCommissionSetting;
use App\Models\CommissionStatus;
use App\Models\AgentDetail;
use App\Models\Course;
use App\Models\Student\Party;
use App\Models\Organisation;
use App\Models\User;
use Illuminate\Http\Request;
use DB;
use File;
use Storage;
use Carbon\Carbon;
use Illuminate\Support\Facades\Hash;

class AgentController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // dd();
        
        $app_settings = Organisation::first();
        // dd($app_settings->add_on('agent'));
        if($app_settings->add_on('agent') == 0){
            // dd('test');
            return 'access deneid...';
        }

        return view('agents.index');
    }

    public function lists()
    {
        // $agents = Agent::with(['detail', 'party'])->orderBy('id', 'desc')->paginate(10);
        $agents = AgentDetail::with(['user'])->orderBy('id', 'desc')->get();
        // dd($agents[190]);
        return $agents;
    }

    public function list_search($data){
        $agents = Agent::with(['detail', 'party'])->whereHas('detail', function($q) use($data){
            $q->where('company_name', 'like', '%'.$data.'%');
        })->orWhereHas('party', function($q) use($data) {
            $q->where('name', 'like', '%' . $data . '%');
        })->orderBy('id', 'desc')->paginate(10);

        return json_encode($agents);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());

        $validator = \Validator::make($request->all(), [
            'agent.company_name' => 'required',
            'agent.agent_name' => 'required',
            'agent.email' => 'required|email',
            'agent.phone' => 'required',
        ]);

        // validator nice names
        $validator->setAttributeNames([
            'agent.company_name'    => 'Company Name',
            'agent.agent_name'      => 'Agent Name',
            'agent.email'           => 'Email',
            'agent.phone'           => 'Phone',
        ]);

        try {
            // start db transaction
            DB::beginTransaction();

            $user = new User;
            $party = new Party;
            $agent_detail = new AgentDetail;

            $party->name = $request->agent['company_name'];
            $party->party_type_id = 2;
            $party->save();
            
            $user->username = $request->agent['email'];
            $user->password = Hash::make('agent123!@#');
            $user->is_active = 0;
            $user->profile_image = 'default.png';
            // $user->user()->associate(\Auth::user());
            $user->party()->associate($party);
            $user->save();
            $user->assignRole('Agent');

            $agent_detail->company_name = $request->agent['company_name'];
            $agent_detail->agent_name = $request->agent['agent_name'];
            $agent_detail->phone = $request->agent['phone'];
            $agent_detail->email = $request->agent['email'];
            $agent_detail->user()->associate($user);
            $agent_detail->user_reference()->associate(\Auth::user());
            $agent_detail->save();
            
            DB::commit();

            // dd($agent);

            return ['status' => 'success'];

        } catch (\Exception $e) {
            // rollback db transactions
            DB::rollBack();

            // return to previous page with errors
            return json_encode(['message' => $e->getMessage(), 'status' => 'error']);
        }


    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Agent  $agent
     * @return \Illuminate\Http\Response
     */
    public function show($agent)
    {
        //
        $courses = Course::all();
        $comm_statuses = CommissionStatus::all();
        
        $agent = AgentDetail::with(['user.party'])->where('id', $agent)->first();

        // dd($agent);

        \JavaScript::put([
            'agent' => $agent,
            'courses' => $courses,
            'comm_statuses' => $comm_statuses
        ]);
        // dd($agent);
        return view('agents.show');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Agent  $agent
     * @return \Illuminate\Http\Response
     */
    public function edit(Agent $agent)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Agent  $agent
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Agent $agent)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Agent  $agent
     * @return \Illuminate\Http\Response
     */
    public function destroy($agent)
    {
        //
        try {
            // start db transaction
            DB::beginTransaction();

            $agent = AgentDetail::with('user.party')->where('id', $agent)->first();

            if(isset($agent->commission_settings[0])){
                foreach ($agent->commission_settings as $key => $value) {
                    $value->delete();
                }
            }
            
            if($agent->user->party){
                $agent->user->party->delete();
            }
            
            if($agent->user){
                $agent->user->delete();
            }
            
            
            $agent->delete();

            DB::commit();

            // dd($agent);

            return ['status' => 'success'];
        } catch (\Exception $e) {
            // rollback db transactions
            DB::rollBack();

            // return to previous page with errors
            return json_encode(['message' => $e->getMessage(), 'status' => 'error']);
        }
        
    }

    public function agent_info($agent_id)
    {
        $agent = Agent::with(['detail', 'party'])->where('id', $agent_id)->first();

        // dd($agent);
        return $agent;
    }

    public function agent_info_update(Request $request, $agent_id)
    {
        try {
            // start db transaction
            DB::beginTransaction();
        // dd($request->agent['id']);
            $agent = Agent::with(['detail', 'party'])->where('id', $agent_id)->first();

            $agent->update([
                'is_active' => isset($request->agent['is_active']) ? $request->agent['is_active'] : null
            ]);

            $agent->party->update(
                ['name' => $request->company_name]
            );
    
            $agent->detail->update(
                $request->agent['detail']
            );

            DB::commit();

            return ['agent'=>$agent, 'status'=>'updated'];

        } catch (\Exception $e) {
            // rollback db transactions
            DB::rollBack();

            // return to previous page with errors
            return ['message' => $e->getMessage(), 'status' => 'error'];
        }
    }

    public function fetch_agent_commission ($agent_id)
    {
        $commissions = AgentCommissionSetting::where('agent_id', $agent_id)->orderBy('id', 'desc')->get();

        $coms = [];

        foreach ($commissions as $key => $value) {
            $coms[] = [
                'id' => $value->id,
                'commission_type_id' => $value->commission_type_id,
                'commission_value' => $value->commission_value,
                'real_commission_value' => $value->real_commission_value. $value->commission_type_id,
                'course_code' => $value->course_code,
                'gst_type' => $value->gst_type,
                'remarks' => $value->remarks,
                'registered_gst' => $value->registered_gst,
                'registered_gst_sign' => $value->registered_gst == 1 ? 'Registered' : 'Not Registered',
                // 'registered_gst_sign' => $value->registered_gst == 1 ? '<i class="fas fa-check" style="color: green;"></i>' : '<i class="fas fa-times" style="color: rgb(231, 74, 59);"></i>',
                'registered_gst_date' => $value->registered_gst_date,
                'starting_student_count' => $value->starting_student_count,
                'starting_commission_value' => $value->starting_commission_value
            ];
        }
        // dd($coms);
        return $coms;
    }

    public function edit_agent_commission($commId)
    {
        $comm = AgentCommissionSetting::where('id', $commId)->first();

        $comm->commission_value = $comm->real_commission_value;
        
        return $comm;
    }

    public function agent_commission_save(Request $request)
    {
        $agent = Agent::with(['commission_settings'])->where('id', $request['agentID'])->first();

        // validate requested inputs
        $validator = \Validator::make($request->all(), [
            'acs.course_code' => 'required_if:acs.all_courses,0',
            'acs.commission_value' => 'required',
            'acs.gst_type' => 'required',
        ]);

        // validator nice names
        $validator->setAttributeNames([
            'acs.course_code'        => 'Course',
            'acs.all_courses'        => 'All Courses',
            'acs.gst_type'           => 'GST Type',
            'acs.commission_value'   => 'Commission Value',
        ]);

        // if request to generate all courses but has commission settings
        if (isset($agent->commission_settings[0]) && isset($request['acs']['all_courses']) && $request['acs']['all_courses'] == 1) {
            return ['status' => 'error', 'msg' => 'Cannot generate all courses.. please remove existing settings before saving.'];
        }

        // dd($request->all());
        // check on validation fail
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }

        try {
            // start db transaction
            DB::beginTransaction();
            $commVal = $request['acs']['gst_type'] == 'Including' ? round(($request['acs']['commission_value'] / 1.1), 2) : $request['acs']['commission_value'];
            
            if (isset($request['acs']['all_courses']) && $request['acs']['all_courses'] == 1) {
                $courses = Course::all();
                foreach ($courses as $key => $value) {
                    $acs = new AgentCommissionSetting;
                    $data = [
                        'commission_type_id' => '%',
                        'commission_value' => $commVal,
                        'course_code' => $value->code,
                        'gst_type' => $request['acs']['gst_type'],
                        'remarks' => isset($request['acs']['remarks']) ? $request['acs']['remarks'] : null,
                        'registered_gst' => isset($request['acs']['registered_gst']) && $request['acs']['registered_gst'] == 1 ? 1 : 0,
                        'registered_gst_date' => isset($request['acs']['registered_gst_date']) && $request['acs']['registered_gst_date'] != null ? Carbon::parse($request['acs']['registered_gst_date'])->format('Y-m-d') : null,
                        'starting_student_count' => isset($request['acs']['starting_student_count']) ? $request['acs']['starting_student_count'] : null,
                        'starting_commission_value' => isset($request['acs']['starting_commission_value']) ? $request['acs']['starting_commission_value'] : null,
                    ];
                    $acs->fill($data);
                    $acs->agent()->associate($agent);
                    $acs->user()->associate(\Auth::user());
                    $acs->save();
                }
            } else {
                
                // $acs = AgentCommissionSetting::find($request['acs']['id']);
                // dump($request['agentID']);
                // dump(isset($request['acs']['id']) ? $request['acs']['id'] : 0);
                $data = AgentCommissionSetting::updateOrCreate(
                    [
                        'id' => isset($request['acs']['id']) ? $request['acs']['id'] : 0,
                        'agent_id' => $request['agentID']
                    ],
                    [
                        'commission_type_id' => '%',
                        'commission_value' => $commVal,
                        'course_code' => $request['acs']['course_code'],
                        'gst_type' => $request['acs']['gst_type'],
                        'remarks' => isset($request['acs']['remarks']) ? $request['acs']['remarks'] : '',
                        'registered_gst' => isset($request['acs']['registered_gst']) && $request['acs']['registered_gst'] == 1 ? 1 : 0,
                        'registered_gst_date' => isset($request['acs']['registered_gst_date']) && $request['acs']['registered_gst_date'] != null ? Carbon::parse($request['acs']['registered_gst_date'])->format('Y-m-d') : null,
                        'starting_student_count' => isset($request['acs']['starting_student_count']) ? $request['acs']['starting_student_count'] : null,
                        'starting_commission_value' => isset($request['acs']['starting_commission_value']) ? $request['acs']['starting_commission_value'] : null,
                    ]
                );
                // dump(Carbon::parse($request['acs']['registered_gst_date'])->format('Y-m-d'));
                // dd($request['acs']['commission_type_id']);
                
                // $acs->agent()->assciate()
                // dump($request->all());
                if(!isset($request['acs']['id'])){
                    $data->agent()->associate($agent);
                    $data->user()->associate(\Auth::user());
                    $data->update();
                    // dump('test');
                }
            }

            // commit db transactions
            DB::commit();

            return ['status' => 'success'];

        } catch (\Exception $e) {
            // rollback db transactions
            DB::rollBack();

            // return to previous page with errors
            return ['status' => 'error', 'msg' => $e->getMessage()];
        }
    }

    public function delete_agent_commission($commId)
    {
        
        // dd($commId);
        $acs = AgentCommissionSetting::find($commId);

        try {
            // start db transaction
            DB::beginTransaction();

            $acs->delete();

            // commit db transactions
            DB::commit();
            return ['status' => 'success'];
        } catch (\Exception $e) {
            // rollback db transactions
            DB::rollBack();

            return ['status' => 'error', 'msg' => $e->getMessage()];
        }
    }


}
